local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local utility = require "emoji.emojiUtility"
local model = require "emoji.model"

-- model contains blendshape
local bsmodel = model:extend();

function bsmodel:new()
  bsmodel.super.new(self);
  self.weights = {}; -- the weights pass to venus engine
  self.has_blendshape = true;
  self.attached_blendshapes = {};
end

function bsmodel:CreateModel(config, attach_to_model, boundingbox, render_before)
  if (config ~= nil) then
    self.config = config;
    self.model = utility.CreateBlendshapeModel(config);
    self:AttachToModel(attach_to_model);  
    self:SetBindBox(boundingbox);
    self:SetRenderQueue(render_before);
  end
end

-- attach to node
function bsmodel:AttachToModel(other_model)  
  if (self.config ~= nil) then
    if other_model~= nil and other_model:HasBlendshape() then
      local attach_config = self.config.attach;
      for key, value in pairs(attach_config) do
        self.attached_blendshapes[key] = value;
      end
    end
  end
  
  bsmodel.super.AttachToModel(self, other_model);
end

function bsmodel:UpdateModel(input_data, def)  
  if (self.model ~= nil and input_data ~= nil) then
    local weights = {};
    local weights_dict = input_data.weights_dict;
    for i = 1, #self.attached_blendshapes do
      -- get the blendshape name
      local blendshapename = self.attached_blendshapes[i];
      local weight = weights_dict[blendshapename] or 0;    
      weights[i] = weight;
    end
    self.model:UpdateBlendshape(weights);
  end
end

return bsmodel;