
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"
local Sticker = require "editorscene.stickerscene"


--renderqueue中的layer名称和对应scene的渲染顺序
local LAYER_FACE_BEAUTY = "FaceBeautify"
local LAYER_EDITOR_MAKE_UP   = "EditorMakeUp"
local LAYER_STYLISH = "Stylish"
local LAYER_STICKER = "Sticker"

local LAYER_FACEBUAUTY_SEQUENCE = -300
local LAYER_MAKEUP_SEQUENCE = -200
local LAYER_STYLISH_SEQUENCE = -100
local LAYER_STICKER_SEQUENCE = 100  --scene的渲染

--编辑器素材统一加载接口
local SceneLoader = {}

--param: preLayer      贴纸上一层的标记
function SceneLoader:Initialize()
  self.sceneList = {};
end

function SceneLoader:Update(spantime)
  self:UpdateFacebeauty(spantime);
  self:UpdateMakeup(spantime);
  self:UpdateStylish(spantime);
  self:UpdateSticker(spantime);
end

function SceneLoader:OnRecordStart()
end

--一次卸载所有素材
function SceneLoader:ReleaseAllResource()
end


-------------------------------------------------------贴纸-----------------------------------------------------------------
--当贴纸加载
function SceneLoader:LoadAsSticker(path)
  --只能加载一个贴纸
  if self.sceneList[LAYER_STICKER] then
    self.sceneList[LAYER_STICKER]:ReleaseSticker();
  end
  
  local rootConfig = venusjson.LaodJsonFile(path);
  if rootConfig.scene then
    renderqueue:Activate(LAYER_STICKER);
    local inputTex = renderqueue:GetTexture(LAYER_STICKER);
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_STICKER,
      inputTex);
    
    --设置ress路径
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    
    local Sticker = Sticker(LAYER_STICKER_SEQUENCE,LAYER_STICKER);
    Sticker:LoadConfig(rootConfig.scene);
    self.sceneList[LAYER_STICKER] = Sticker;
  end
  return true;
end

function SceneLoader:UpdateSticker(spantime)
  local Sticker = self.sceneList[LAYER_STICKER];
  if Sticker then
    Sticker:Update(spantime);
  end
end

--卸载贴纸
function SceneLoader:ReleaseSticker()
  local Sticker = self.sceneList[LAYER_STICKER];
  if Sticker then
    Sticker:ReleaseResource();
  end
  self.sceneList[LAYER_STICKER] = nil;
  return true;
end

function SceneLoader:OnRecordStartSticker()
end

function SceneLoader:OnRecordStopSticker()
end


-----------------------------------------------------------------------美妆-----------------------------------------------------------------
--param: path  素材路径
--param: makeupType  美妆类型
function SceneLoader:LoadAsMakeup(path,makeupType)
end

function SceneLoader:UpdateMakeup(spantime)
end

--param: makeupType  美妆类型
function SceneLoader:ReleaseMakeup(makeupType)
end

function SceneLoader:OnRecordStartMakeup()
end

function SceneLoader:OnRecordStopMakeup()
end






--------------------------------------------------------------美颜-----------------------------------------------------------------------
function SceneLoader:UpdateFacebeauty(spantime)
end

function SceneLoader:ReleaseFacebeauty()
end

function SceneLoader:OnRecordStartFacebeauty()
end

function SceneLoader:OnRecordStopFacebeauty()
end



--------------------------------------------------------------风格滤镜-----------------------------------------------------------------------
function SceneLoader:UpdateStylish(spantime)
end

function SceneLoader:ReleaseStylish()
end

function SceneLoader:OnRecordStartStylish()
end

function SceneLoader:OnRecordStartStylish()
end




return SceneLoader;
