local venuscore = require "venuscore"
local apolloengine = require "apolloengine"

local TouchNodeBehavior = venuscore.VenusBehavior:extend("TouchNodeBehavior");

function TouchNodeBehavior:new()
  self.node = nil;
  self.baseobject = {};
  self.maincam = {};
  --self.startFrameIndex = 0
  --self.stopFrameIndex = 0
  self.lastpts = 0
  self.lastptsInited = false;
end

function TouchNodeBehavior:initBehaviorData(node, baseobject)
  self.node = node;
  self.baseobject = baseobject;
end

function TouchNodeBehavior:ConfigRenderTarget(rt)
  LOG("TouchNodeBehavior:ConfigRenderTarget");
  if #self.maincam > 0 then
    for i=1, #self.maincam do
      local cameracom = self.maincam[i];
      cameracom:AttachRenderTarget(rt);
    end
  else
    for i=1, #self.baseobject do
      local cameracom = self.baseobject[i]:GetComponent(apolloengine.Node.CT_CAMERA);
      if cameracom and cameracom:GetAttachedRenderTarget() == nil then
        cameracom:AttachRenderTarget(rt);
        table.insert(self.maincam, cameracom);
      end
    end
  end
end

function TouchNodeBehavior:SetFrameRange(startFrameIndex, stopFrameIndex)
--  LOG("SetFrameRange " .. tostring(startFrameIndex) .. ", " .. tostring(stopFrameIndex))
--  self.startFrameIndex = startFrameIndex
--  self.stopFrameIndex  = stopFrameIndex
end

--素材先预览后应用，需要重置，否则update传的deltaTs不正确
function TouchNodeBehavior:ResetPtsInited()
  self.lastptsInited = false
end

function TouchNodeBehavior:updateFrameInfo(frameIndex, pts)
    self.node.Active = true
    self:_UpdateWallTs(pts)
end

function TouchNodeBehavior:_UpdateWallTs(pts)
  local deltaTs = 0.0;
  if _PLATFORM_WINDOWS then --windows测试代码
    deltaTs = pts;
  else
    if self.lastptsInited ~= true then
      self.lastptsInited = true
      deltaTs = 0.033  --第一帧deltaTs固定传0.033
    else
      deltaTs = (pts - self.lastpts) * 0.001;
    end
    self.lastpts = pts;
  end
  --LOG("TouchNodeBehavior:_UpdateWallTs delta = ".. deltaTs)
  self:_UpdateNode(self.node, deltaTs);
end

function TouchNodeBehavior:_UpdateNode(node,deltaTs)
  if node:isActiveHierarchy() == true then
    if node.Update then
      node:Update(deltaTs)
    end
    local subNodes = node:GetChildrens();
    for k,v in pairs(subNodes) do
      self:_UpdateNode(v, deltaTs);
    end
  end
end

return TouchNodeBehavior;