local venuscore = require "venuscore"
local apolloengine = require "apolloengine"

local MixNodeBehavior = venuscore.VenusBehavior:extend("MixNodeBehavior");

function MixNodeBehavior:new()
  self.node = nil;
  self.baseobject = {};
  self.maincam = {};
  self.startFrameIndex = 0
  self.stopFrameIndex = 0
  self.lastpts = 0
end

function MixNodeBehavior:initBehaviorData(node, baseobject)
  self.node = node;
  self.baseobject = baseobject;
end

function MixNodeBehavior:ConfigRenderTarget(rt)
  LOG("MixNodeBehavior:ConfigRenderTarget");
  if #self.maincam > 0 then
    for i=1, #self.maincam do
      local cameracom = self.maincam[i];
      cameracom:AttachRenderTarget(rt);
    end
  else
    for i=1, #self.baseobject do
      local cameracom = self.baseobject[i]:GetComponent(apolloengine.Node.CT_CAMERA);
      if cameracom and cameracom:GetAttachedRenderTarget() == nil then
        cameracom:AttachRenderTarget(rt);
        table.insert(self.maincam, cameracom);
      end
    end
  end
end

function MixNodeBehavior:SetFrameRange(startFrameIndex, stopFrameIndex)
  LOG("SetFrameRange " .. tostring(startFrameIndex) .. ", " .. tostring(stopFrameIndex))
  self.startFrameIndex = startFrameIndex
  self.stopFrameIndex  = stopFrameIndex
end

function MixNodeBehavior:checkActiveStatus(frameIndex)
  if frameIndex >= self.startFrameIndex and frameIndex <= self.stopFrameIndex then
    return true
  end
  return false
end

function MixNodeBehavior:updateFrameInfo(frameIndex, pts)
  if frameIndex >= self.startFrameIndex and frameIndex <= self.stopFrameIndex then
    self:_UpdateWallTs(pts)
  end
end

function MixNodeBehavior:_UpdateWallTs(pts)
  local deltaTs = 0.0;
  if _PLATFORM_WINDOWS then --windows测试代码
    deltaTs = pts;
  else
    deltaTs = (pts - self.lastpts) * 0.001;
    self.lastpts = pts;
  end
  -- LOG("MixNodeBehavior _UpdateWallTs" .. tostring(pts) .. "self.lastpts" .. tostring(self.lastpts) .. "def" .. tostring(deltaTs));
  self:_UpdateNode(self.node, deltaTs);
end

function MixNodeBehavior:_UpdateNode(node,deltaTs)
  if node:isActiveHierarchy() == true then
    if node.Update then
      node:Update(deltaTs)
    end
    local subNodes = node:GetChildrens();
    for k,v in pairs(subNodes) do
      self:_UpdateNode(v, deltaTs);
    end
  end
end

return MixNodeBehavior;