local transition = require "facecute.transitions.transition"
local transitionMakeup = transition:extend();

function transitionMakeup:new(ht, immortal, makeupType)
  transitionMakeup.super.new(self,ht,immortal);  
  self.makeuptransitions = {}
end

function transitionMakeup:MakeupParseConfig(config,makeupType)
  self:ParseConfig(config);
  for _, trans in ipairs(self.transitions) do
    table.insert(self.makeuptransitions, {trans,makeupType});
  end
  
  self.transitions = {};
  for _, value in ipairs(self.makeuptransitions) do
    table.insert(self.transitions, value[1]);
  end
end

function transitionMakeup:ReleaseMakeup(makeupType)
  for pos, node in ipairs(self.makeuptransitions) do
    if node[2] == makeupType then
      table.remove(self.makeuptransitions, pos)
    end
  end
end

return transitionMakeup;