local triggerdefined = require "videodecet.defined"
local videodecet = require "videodecet"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Condition'
require "utility"

local targetaction = b3.Class("TargetAction", b3.Condition)

function targetaction:ctor(properties, target)
  b3.Condition.ctor(self)
	self.name = "TargetAction"
  local sid = properties.id;
  self.actionid = triggerdefined.triggerType[sid];
  if not self.id then
    ERROR("unkown action id ".. sid);
  else
    videodecet:ActiveActions({self.actionid});
  end  
end

function targetaction:tick(tick)
  local blackboard = tick.blackboard;
  local action = blackboard:get("actionscope");
  if action then
    for _, act in ipairs(action) do
      if act:GetActionID() == self.actionid then
        blackboard:set("activetarget", act);
        return b3.SUCCESS;
      end
    end
  end  
	return b3.FAILURE;
end

return targetaction;