
function DefineParams()
	Properties = 
	{
		
MASK_TEXTURE = { "Mask Tex", TEXTURE2D, "white" },
CUSTOM_TEXTURE = { "Custom Tex", TEXTURE2D, "white" },
MASK_CHANNEL = { "Mask Channel", VEC3, "1.0,1.0,1.0" },
UV_SCALER = { "UV Scale", VEC2, "1.0,1.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"ForwardBase","PostEffect"
	}

ShaderName = "ImageBlitTrasnparent"
RenderQueue = "Opaque+1"
end


function ForwardBase()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA,ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUSTOM_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_CHANNEL",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UV_SCALER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * _glesVertex);
  highp vec2 tmpvar_3;
  tmpvar_3.x = ((tmpvar_2.x + 1.0) / 2.0);
  tmpvar_3.y = (1.0 - ((tmpvar_2.y + 1.0) / 2.0));
  gl_Position = tmpvar_2;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D MASK_TEXTURE;
uniform sampler2D CUSTOM_TEXTURE;
uniform highp vec3 MASK_CHANNEL;
uniform highp vec2 UV_SCALER;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 mask_1;
  highp vec4 custom_2;
  highp vec2 tmpvar_3;
  tmpvar_3 = (((xlv_TEXCOORD0 - vec2(0.5, 0.5)) * UV_SCALER) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (CUSTOM_TEXTURE, tmpvar_3);
  custom_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (MASK_TEXTURE, xlv_TEXCOORD1);
  mask_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = custom_2.xyz;
  tmpvar_6.w = (((
    (mask_1.z * MASK_CHANNEL.x)
   + 
    (mask_1.y * MASK_CHANNEL.y)
  ) + (mask_1.x * MASK_CHANNEL.z)) * custom_2.w);
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
}

end




function PostEffect()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { UNIVERSAL_POST_EFFECT }



Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUSTOM_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "MASK_CHANNEL",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UV_SCALER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec4 tmpvar_2;
  tmpvar_2 = (tmpvar_1 * _glesVertex);
  highp vec2 tmpvar_3;
  tmpvar_3.x = ((tmpvar_2.x + 1.0) / 2.0);
  tmpvar_3.y = (1.0 - ((tmpvar_2.y + 1.0) / 2.0));
  gl_Position = tmpvar_2;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = tmpvar_3;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D MASK_TEXTURE;
uniform sampler2D CUSTOM_TEXTURE;
uniform highp vec3 MASK_CHANNEL;
uniform highp vec2 UV_SCALER;
in highp vec2 xlv_TEXCOORD0;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec4 mask_1;
  highp vec4 custom_2;
  highp vec2 tmpvar_3;
  tmpvar_3 = (((xlv_TEXCOORD0 - vec2(0.5, 0.5)) * UV_SCALER) + vec2(0.5, 0.5));
  lowp vec4 tmpvar_4;
  tmpvar_4 = texture (CUSTOM_TEXTURE, tmpvar_3);
  custom_2 = tmpvar_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture (MASK_TEXTURE, xlv_TEXCOORD1);
  mask_1 = tmpvar_5;
  highp vec4 tmpvar_6;
  tmpvar_6.xyz = custom_2.xyz;
  tmpvar_6.w = (((
    (mask_1.z * MASK_CHANNEL.x)
   + 
    (mask_1.y * MASK_CHANNEL.y)
  ) + (mask_1.x * MASK_CHANNEL.z)) * custom_2.w);
  _glesFragData[0] = tmpvar_6;
}

]===],
	},
}

end