
#DEFPARAMS
MOTION_TEXTURE = { "Motion Tex", TEXTURE2D, "white" },
RADIUS = { "Radius", FLOAT, "0.0" },
UNIFORM_OFFSET = { "Offset", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "ShineSeperateBlur"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D MOTION_TEXTURE;
float RADIUS;
float2 UNIFORM_OFFSET;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	int radius = int(RADIUS);
	float2 cur_pos = i.uv - UNIFORM_OFFSET * float(radius);
	
	int total = radius * 2 + 1;
	float sum = 0.0;

	for (int i = 0; i < total; i++)
	{
		sum += tex2D(MOTION_TEXTURE, cur_pos).r;
		cur_pos += UNIFORM_OFFSET;
	}
	
	sum /= float(total);
	return float4(sum, sum, sum, sum);
}
ENDCG
#END
