
function DefineParams()
	Properties = 
	{
		
MOTION_TEXTURE = { "Motion Tex", TEXTURE2D, "white" },
RADIUS = { "Radius", FLOAT, "0.0" },
UNIFORM_OFFSET = { "Offset", VEC2, "0.0,0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "ShineSeperateBlur"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "MOTION_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "RADIUS",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_OFFSET",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D MOTION_TEXTURE;
uniform highp float RADIUS;
uniform highp vec2 UNIFORM_OFFSET;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp int i_1_1;
  highp float sum_2;
  highp int total_3;
  highp vec2 cur_pos_4;
  highp int tmpvar_5;
  tmpvar_5 = int(RADIUS);
  cur_pos_4 = (xlv_TEXCOORD0 - (UNIFORM_OFFSET * float(tmpvar_5)));
  highp int tmpvar_6;
  tmpvar_6 = ((tmpvar_5 * 2) + 1);
  total_3 = tmpvar_6;
  sum_2 = 0.0;
  i_1_1 = 0;
  for (; i_1_1 < total_3; i_1_1++, cur_pos_4 = (cur_pos_4 + UNIFORM_OFFSET)) {
    lowp vec4 tmpvar_7;
    tmpvar_7 = texture (MOTION_TEXTURE, cur_pos_4);
    sum_2 = (sum_2 + tmpvar_7.x);
  };
  sum_2 = (sum_2 / float(tmpvar_6));
  highp vec4 tmpvar_8;
  tmpvar_8.x = sum_2;
  tmpvar_8.y = sum_2;
  tmpvar_8.z = sum_2;
  tmpvar_8.w = sum_2;
  _glesFragData[0] = tmpvar_8;
}

]===],
	},
}

end
