

#DEFPARAMS
#END

#DEFTAG
ShaderName = "LabColor"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_uDab;
sampler2D TEXTURE_uLut;
float UNIFORM_uGa;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 color = tex2D(TEXTURE_uDab, i.uv);
	color.rgb = LUT(float4(color.rgb, 1.0), TEXTURE_uLut).rgb;
    color.rgb = rgb2lab(color.rgb);
    color.r = pow(color.r, UNIFORM_uGa);
	return color;
}
ENDCG
#END
