
#DEFPARAMS
HISTORICAL_FRAME1 = { "Frame Tex1", TEXTURE2D, "white" },
HISTORICAL_FRAME2 = { "Frame Tex2", TEXTURE2D, "white" },
HISTORICAL_FRAME3 = { "Frame Tex3", TEXTURE2D, "white" },
HISTORICAL_FRAME4 = { "Frame Tex4", TEXTURE2D, "white" },
FRAME_SIZE = { "Frame size", FLOAT, "0.0" },
CUR_FRAME_ID = { "Current ID", FLOAT, "0.0" },
DIRECTION = { "Direction", FLOAT, "0.0" },
INTERVAL = { "Interval", FLOAT, "0.0" },
ROW_FRAME_NUM_PER_TEX = { "Row Frame number per Tex", FLOAT, "0.0" },
COL_FRAME_NUM_PER_TEX = { "Col Frame number per Tex", FLOAT, "0.0" },
TOTAL_PERIOD = { "TOTAL_PERIOD", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "Displace"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D HISTORICAL_FRAME1;
sampler2D HISTORICAL_FRAME2;
sampler2D HISTORICAL_FRAME3;
sampler2D HISTORICAL_FRAME4;
float FRAME_SIZE;
float CUR_FRAME_ID;
float DIRECTION;
float INTERVAL;
float ROW_FRAME_NUM_PER_TEX;
float COL_FRAME_NUM_PER_TEX;
float TOTAL_PERIOD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float customMod(float number, float denom)
{
  float tfactor = number / denom;
  float res = frac(tfactor) * denom;
  if(res < 0)
  {
    res += denom;
  }
  return res;
}

float4 frag(v2f i) : SV_Target
{
	  int iFrameSize = int(FRAME_SIZE);
    int iCurFrameID = int(CUR_FRAME_ID);
    int iRowFrameNumPerTex = int(ROW_FRAME_NUM_PER_TEX);
    int iColFrameNumPerTex = int(COL_FRAME_NUM_PER_TEX);

    int minus_frames = 0;
    if (DIRECTION < 0.)     //x - direction
    {
        if (INTERVAL > 0.)
        {
            minus_frames = int(i.uv.x / INTERVAL);
        }
        else
        {
            minus_frames = int((1.0 - i.uv.x) / abs(INTERVAL));
        }
    }
    else
    {
        if (INTERVAL < 0.)
        {
            minus_frames = int(i.uv.y / INTERVAL);
        }
        else
        {
            minus_frames = int((1.0 - i.uv.y) / abs(INTERVAL));
        }
    }
    
    float frame_delay = TOTAL_PERIOD / (1.0 / abs(INTERVAL));
    minus_frames = int((frame_delay / 1000.0) * 30.0) * minus_frames;
    
    int frame_id = int(customMod(iCurFrameID - minus_frames, iFrameSize));

    int FRAME_NUM_PER_TEX = iRowFrameNumPerTex * iColFrameNumPerTex;      
    int tex_id = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = int(customMod(frame_id, FRAME_NUM_PER_TEX));
    
    float x_scale = 1.0 / iRowFrameNumPerTex;
    float y_scale = 1.0 / iColFrameNumPerTex;

    int divide = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * int(customMod(local_frame_id, iRowFrameNumPerTex));
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - divide);

    float2 tex_pos = float2(tex_x_start, tex_y_start) + float2(x_scale, y_scale) * i.uv;

    float3 rgb = float3(0.0, 0.0, 0.0);
    if (tex_id == 0)
      rgb = tex2D(HISTORICAL_FRAME1, tex_pos).rgb;
    else if (tex_id == 1)
      rgb = tex2D(HISTORICAL_FRAME2, tex_pos).rgb;
    else if (tex_id == 2)
      rgb = tex2D(HISTORICAL_FRAME3, tex_pos).rgb;
    else if (tex_id == 3)
      rgb = tex2D(HISTORICAL_FRAME4, tex_pos).rgb;

    return float4(rgb, 1.0);
}
ENDCG
#END
