
function DefineParams()
	Properties = 
	{
		
HISTORICAL_FRAME1 = { "Frame Tex1", TEXTURE2D, "white" },
HISTORICAL_FRAME2 = { "Frame Tex2", TEXTURE2D, "white" },
HISTORICAL_FRAME3 = { "Frame Tex3", TEXTURE2D, "white" },
HISTORICAL_FRAME4 = { "Frame Tex4", TEXTURE2D, "white" },
FRAME_SIZE = { "Frame size", FLOAT, "0.0" },
CUR_FRAME_ID = { "Current ID", FLOAT, "0.0" },
DIRECTION = { "Direction", FLOAT, "0.0" },
INTERVAL = { "Interval", FLOAT, "0.0" },
ROW_FRAME_NUM_PER_TEX = { "Row Frame number per Tex", FLOAT, "0.0" },
COL_FRAME_NUM_PER_TEX = { "Col Frame number per Tex", FLOAT, "0.0" },
TOTAL_PERIOD = { "TOTAL_PERIOD", FLOAT, "0.0" },

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Displace"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "HISTORICAL_FRAME1",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME3",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HISTORICAL_FRAME4",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_SIZE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CUR_FRAME_ID",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "DIRECTION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INTERVAL",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "ROW_FRAME_NUM_PER_TEX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "COL_FRAME_NUM_PER_TEX",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TOTAL_PERIOD",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[uniform sampler2D HISTORICAL_FRAME1;
uniform sampler2D HISTORICAL_FRAME2;
uniform sampler2D HISTORICAL_FRAME3;
uniform sampler2D HISTORICAL_FRAME4;
uniform highp float FRAME_SIZE;
uniform highp float CUR_FRAME_ID;
uniform highp float DIRECTION;
uniform highp float INTERVAL;
uniform highp float ROW_FRAME_NUM_PER_TEX;
uniform highp float COL_FRAME_NUM_PER_TEX;
uniform highp float TOTAL_PERIOD;
varying highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 rgb_1;
  highp int minus_frames_2;
  highp int tmpvar_3;
  tmpvar_3 = int(FRAME_SIZE);
  highp int tmpvar_4;
  tmpvar_4 = int(CUR_FRAME_ID);
  highp int tmpvar_5;
  tmpvar_5 = int(ROW_FRAME_NUM_PER_TEX);
  highp int tmpvar_6;
  tmpvar_6 = int(COL_FRAME_NUM_PER_TEX);
  minus_frames_2 = 0;
  if ((DIRECTION < 0.0)) {
    if ((INTERVAL > 0.0)) {
      minus_frames_2 = int((xlv_TEXCOORD0.x / INTERVAL));
    } else {
      minus_frames_2 = int(((1.0 - xlv_TEXCOORD0.x) / abs(INTERVAL)));
    };
  } else {
    if ((INTERVAL < 0.0)) {
      minus_frames_2 = int((xlv_TEXCOORD0.y / INTERVAL));
    } else {
      minus_frames_2 = int(((1.0 - xlv_TEXCOORD0.y) / abs(INTERVAL)));
    };
  };
  minus_frames_2 = (int((
    ((TOTAL_PERIOD / (1.0/(abs(INTERVAL)))) / 1000.0)
   * 30.0)) * minus_frames_2);
  highp float denom_7;
  denom_7 = float(tmpvar_3);
  highp float res_8;
  highp float tmpvar_9;
  tmpvar_9 = (fract((
    float((tmpvar_4 - minus_frames_2))
   / denom_7)) * denom_7);
  res_8 = tmpvar_9;
  if ((tmpvar_9 < 0.0)) {
    res_8 = (tmpvar_9 + denom_7);
  };
  highp int tmpvar_10;
  tmpvar_10 = int(res_8);
  highp int tmpvar_11;
  tmpvar_11 = (tmpvar_5 * tmpvar_6);
  highp int tmpvar_12;
  tmpvar_12 = (tmpvar_10 / tmpvar_11);
  highp float denom_13;
  denom_13 = float(tmpvar_11);
  highp float res_14;
  highp float tmpvar_15;
  tmpvar_15 = (fract((
    float(tmpvar_10)
   / denom_13)) * denom_13);
  res_14 = tmpvar_15;
  if ((tmpvar_15 < 0.0)) {
    res_14 = (tmpvar_15 + denom_13);
  };
  highp int tmpvar_16;
  tmpvar_16 = int(res_14);
  highp float tmpvar_17;
  tmpvar_17 = (1.0/(float(tmpvar_5)));
  highp float tmpvar_18;
  tmpvar_18 = (1.0/(float(tmpvar_6)));
  highp int tmpvar_19;
  tmpvar_19 = (tmpvar_16 / tmpvar_5);
  highp float denom_20;
  denom_20 = float(tmpvar_5);
  highp float res_21;
  highp float tmpvar_22;
  tmpvar_22 = (fract((
    float(tmpvar_16)
   / denom_20)) * denom_20);
  res_21 = tmpvar_22;
  if ((tmpvar_22 < 0.0)) {
    res_21 = (tmpvar_22 + denom_20);
  };
  highp vec2 tmpvar_23;
  tmpvar_23.x = (tmpvar_17 * float(int(res_21)));
  tmpvar_23.y = (tmpvar_18 * float((
    (tmpvar_6 - 1)
   - tmpvar_19)));
  highp vec2 tmpvar_24;
  tmpvar_24.x = tmpvar_17;
  tmpvar_24.y = tmpvar_18;
  highp vec2 tmpvar_25;
  tmpvar_25 = (tmpvar_23 + (tmpvar_24 * xlv_TEXCOORD0));
  rgb_1 = vec3(0.0, 0.0, 0.0);
  if ((tmpvar_12 == 0)) {
    lowp vec4 tmpvar_26;
    tmpvar_26 = texture2D (HISTORICAL_FRAME1, tmpvar_25);
    rgb_1 = tmpvar_26.xyz;
  } else {
    if ((tmpvar_12 == 1)) {
      lowp vec4 tmpvar_27;
      tmpvar_27 = texture2D (HISTORICAL_FRAME2, tmpvar_25);
      rgb_1 = tmpvar_27.xyz;
    } else {
      if ((tmpvar_12 == 2)) {
        lowp vec4 tmpvar_28;
        tmpvar_28 = texture2D (HISTORICAL_FRAME3, tmpvar_25);
        rgb_1 = tmpvar_28.xyz;
      } else {
        if ((tmpvar_12 == 3)) {
          lowp vec4 tmpvar_29;
          tmpvar_29 = texture2D (HISTORICAL_FRAME4, tmpvar_25);
          rgb_1 = tmpvar_29.xyz;
        };
      };
    };
  };
  highp vec4 tmpvar_30;
  tmpvar_30.w = 1.0;
  tmpvar_30.xyz = rgb_1;
  gl_FragData[0] = tmpvar_30;
}

]===],
	},
}

end
