

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DirFinal"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_uDab;
float2 UNIFORM_uOs;
float UNIFORM_uHiu;
float UNIFORM_uVer;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float k = gauss(0.0, UNIFORM_uHiu);
    float sum = k;
    float4 fvb = tex2D(TEXTURE_uDab, i.uv);
    float3 result;
    //if (abs(uVer - 2.0) < 0.0001) {
        result = float3(decode(fvb), 0.0) * k;
    //}
    //else {
    //    result = fvb.xyz * k;
    //}

    for (int j = 1; j <= 3; ++j) {
        k = gauss(float(j), UNIFORM_uHiu);
        sum += k + k;
        float2 offset = float2(0.0, UNIFORM_uOs.y * float(j));

        float4 xd0 = tex2D(TEXTURE_uDab, i.uv + offset);
        float4 xd1 = tex2D(TEXTURE_uDab, i.uv - offset);
        //if (abs(uVer - 2.0) < 0.0001) {
            result += float3(decode(xd0), 0.0) * k;
            result += float3(decode(xd1), 0.0) * k;
        //}
        //else {
        //    result += xd0.xyz * k;
        //    result += xd1.xyz * k;
        //}
    }
    result /= sum;

    //if (abs(uVer - 2.0) < 0.0001) {
        return encode(result.xy);
    //}
    //else {
    //    float kedc = ( result.x + result.z + sqrt(fsqr(result.x - result.z) + 4. * result.y * result.y) ) / 2.;
    //    vec2 v1 = vec2(kedc - result.x, -result.y);
    //    v1 = length(v1) > 0.0 ? normalize(v1) : vec2(0., 1.);
    //    gl_FragColor = vec4(v1, 0., 0.);
    //}
    // gl_FragColor.rgb = result;
}
ENDCG
#END
