function DefineParams()
	Properties = 
	{
		
UNIFORM_LEFT_EYE = {"UNIFORM_LEFT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RIGHT_EYE = {"UNIFORM_RIGHT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RADIUS = {"UNIFORM_RADIUS", VEC2, "1.0,1.0"},
UNIFORM_RATIOASPECT = {"UNIFORM_RATIOASPECT", FLOAT, "1.0"},
UNIFORM_FACECOEF = {"UNIFORM_FACECOEF", FLOAT, "1.0"},
UNIFORM_CHINCOEF = {"UNIFORM_CHINCOEF", FLOAT, "1.0"},
UNIFORM_NOSECOEF = {"UNIFORM_NOSECOEF", FLOAT, "1.0"},
UNIFORM_MOUTHCOEF = {"UNIFORM_MOUTHCOEF", FLOAT, "1.0"},
UNIFORM_SCALERATIO = {"UNIFORM_SCALERATIO", FLOAT, "1.0"},
UNIFORM_NOSELENGTH_COEF = {"UNIFORM_NOSELENGTH_COEF", FLOAT, "1.0"},
UNIFORM_HAIRLINECOEF = {"UNIFORM_HAIRLINECOEF", FLOAT, "1.0"},
UNIFORM_INNERCANTHUS_COEF = {"UNIFORM_INNERCANTHUS_COEF", FLOAT, "1.0"},
UNIFORM_OUTERCANTHUS_COEF = {"UNIFORM_OUTERCANTHUS_COEF", FLOAT, "1.0"},
UNIFORM_PHILTRUMCOEF = {"UNIFORM_PHILTRUMCOEF", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "biggereyes"
RenderQueue = "Overlay"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LIKEEVERSION",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LEFT_EYE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_RIGHT_EYE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_RADIUS",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EYECORNERPOINTS",
				varType = "float2",
				varSit = "",
				varNum = "8",
				varRegIndex = "0",
				varRegCount = "8",
			},
			{
				varName = "UNIFORM_RATIOASPECT",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_PTS",
				varType = "float4",
				varSit = "",
				varNum = "42",
				varRegIndex = "0",
				varRegCount = "42",
			},
			{
				varName = "UNIFORM_FACECOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FACEPARA",
				varType = "float2",
				varSit = "",
				varNum = "42",
				varRegIndex = "0",
				varRegCount = "42",
			},
			{
				varName = "FACEPARARADIUS",
				varType = "float2",
				varSit = "",
				varNum = "42",
				varRegIndex = "0",
				varRegCount = "42",
			},
			{
				varName = "UNIFORM_NOSECOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_MOUTHCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALERATIO",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_ZOOMSCALE",
				varType = "float3x3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NOSEPARAMS",
				varType = "float2",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "NOSEPOINTS",
				varType = "float4",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "MOUTHPARAMS",
				varType = "float2",
				varSit = "",
				varNum = "2",
				varRegIndex = "0",
				varRegCount = "2",
			},
			{
				varName = "MOUTHPOINTS",
				varType = "float2",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "MOUTHTRIANGLEPOINTSOUECE",
				varType = "float2",
				varSit = "",
				varNum = "30",
				varRegIndex = "0",
				varRegCount = "30",
			},
			{
				varName = "MOUTHTRIANGLEPOINTTARGET",
				varType = "float2",
				varSit = "",
				varNum = "30",
				varRegIndex = "0",
				varRegCount = "30",
			},
			{
				varName = "MOUTHTRIANGLES",
				varType = "float3",
				varSit = "",
				varNum = "47",
				varRegIndex = "0",
				varRegCount = "47",
			},
			{
				varName = "UNIFORM_EYEAD_LEFT_FROM",
				varType = "float2",
				varSit = "",
				varNum = "16",
				varRegIndex = "0",
				varRegCount = "16",
			},
			{
				varName = "UNIFORM_EYEAD_LEFT_TO",
				varType = "float2",
				varSit = "",
				varNum = "16",
				varRegIndex = "0",
				varRegCount = "16",
			},
			{
				varName = "UNIFORM_EYEAD_RIGHT_FROM",
				varType = "float2",
				varSit = "",
				varNum = "16",
				varRegIndex = "0",
				varRegCount = "16",
			},
			{
				varName = "UNIFORM_EYEAD_RIGHT_TO",
				varType = "float2",
				varSit = "",
				varNum = "16",
				varRegIndex = "0",
				varRegCount = "16",
			},
			{
				varName = "UNIFORM_EYEAD_TRIANGLE",
				varType = "float3",
				varSit = "",
				varNum = "22",
				varRegIndex = "0",
				varRegCount = "22",
			},
			{
				varName = "UNIFORM_CHINCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "CHINPOINTS",
				varType = "float4",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "CHINPARA",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "CHINPARARADIUS",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "UNIFORM_PHILTRUMCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "PHILTRUMPARAMS",
				varType = "float2",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "PHILTRUMPOINTS",
				varType = "float4",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "UNIFORM_HAIRLINECOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "HAIRLINEPOINTS",
				varType = "float4",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "HAIRLINEPARA",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "HAIRLINEPARARADIUS",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "UNIFORM_NOSELENGTH_PTS",
				varType = "float4",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "UNIFORM_NOSELENGTH_COEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "NOSELENGTH_PARAM",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "NOSELENGTH_PARAMRADIUS",
				varType = "float2",
				varSit = "",
				varNum = "9",
				varRegIndex = "0",
				varRegCount = "9",
			},
			{
				varName = "UNIFORM_INNERCANTHUS_PTS",
				varType = "float4",
				varSit = "",
				varNum = "2",
				varRegIndex = "0",
				varRegCount = "2",
			},
			{
				varName = "UNIFORM_INNERCANTHUS_COEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "INNERCANTHUS_PARAM",
				varType = "float2",
				varSit = "",
				varNum = "2",
				varRegIndex = "0",
				varRegCount = "2",
			},
			{
				varName = "INNERCANTHUS_PARAMRADIUS",
				varType = "float2",
				varSit = "",
				varNum = "2",
				varRegIndex = "0",
				varRegCount = "2",
			},
			{
				varName = "UNIFORM_OUTERCANTHUS_PTS",
				varType = "float4",
				varSit = "",
				varNum = "6",
				varRegIndex = "0",
				varRegCount = "6",
			},
			{
				varName = "UNIFORM_OUTERCANTHUS_COEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "OUTERCANTHUS_PARAM",
				varType = "float2",
				varSit = "",
				varNum = "6",
				varRegIndex = "0",
				varRegCount = "6",
			},
			{
				varName = "OUTERCANTHUS_PARAMRADIUS",
				varType = "float2",
				varSit = "",
				varNum = "6",
				varRegIndex = "0",
				varRegCount = "6",
			},
			{
				varName = "UNIFORM_EYEBROWCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_LIPCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EYEADCOEF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "EYEBROWPOINTS",
				varType = "float4",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "EYEBROWPARA",
				varType = "float2",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			{
				varName = "EYEBROWPARARADIUS",
				varType = "float2",
				varSit = "",
				varNum = "4",
				varRegIndex = "0",
				varRegCount = "4",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp float UNIFORM_LIKEEVERSION;
uniform highp vec2 UNIFORM_LEFT_EYE;
uniform highp vec2 UNIFORM_RIGHT_EYE;
uniform highp vec2 UNIFORM_RADIUS;
uniform highp vec2 EYECORNERPOINTS[8];
uniform highp float UNIFORM_RATIOASPECT;
uniform highp vec4 UNIFORM_PTS[42];
uniform highp float UNIFORM_FACECOEF;
uniform highp vec2 FACEPARA[42];
uniform highp vec2 FACEPARARADIUS[42];
uniform highp float UNIFORM_NOSECOEF;
uniform highp float UNIFORM_MOUTHCOEF;
uniform highp float UNIFORM_SCALERATIO;
uniform highp mat3 UNIFORM_ZOOMSCALE;
uniform highp vec2 NOSEPARAMS[4];
uniform highp vec4 NOSEPOINTS[4];
uniform highp vec2 MOUTHPARAMS[2];
uniform highp vec2 MOUTHPOINTS[4];
uniform highp vec2 MOUTHTRIANGLEPOINTSOUECE[30];
uniform highp vec2 MOUTHTRIANGLEPOINTTARGET[30];
uniform highp vec3 MOUTHTRIANGLES[47];
uniform highp vec2 UNIFORM_EYEAD_LEFT_FROM[16];
uniform highp vec2 UNIFORM_EYEAD_LEFT_TO[16];
uniform highp vec2 UNIFORM_EYEAD_RIGHT_FROM[16];
uniform highp vec2 UNIFORM_EYEAD_RIGHT_TO[16];
uniform highp vec3 UNIFORM_EYEAD_TRIANGLE[22];
uniform highp float UNIFORM_CHINCOEF;
uniform highp vec4 CHINPOINTS[9];
uniform highp vec2 CHINPARA[9];
uniform highp vec2 CHINPARARADIUS[9];
uniform highp float UNIFORM_PHILTRUMCOEF;
uniform highp vec2 PHILTRUMPARAMS[4];
uniform highp vec4 PHILTRUMPOINTS[4];
uniform highp float UNIFORM_HAIRLINECOEF;
uniform highp vec4 HAIRLINEPOINTS[9];
uniform highp vec2 HAIRLINEPARA[9];
uniform highp vec2 HAIRLINEPARARADIUS[9];
uniform highp vec4 UNIFORM_NOSELENGTH_PTS[9];
uniform highp float UNIFORM_NOSELENGTH_COEF;
uniform highp vec2 NOSELENGTH_PARAM[9];
uniform highp vec2 NOSELENGTH_PARAMRADIUS[9];
uniform highp vec4 UNIFORM_INNERCANTHUS_PTS[2];
uniform highp float UNIFORM_INNERCANTHUS_COEF;
uniform highp vec2 INNERCANTHUS_PARAM[2];
uniform highp vec2 INNERCANTHUS_PARAMRADIUS[2];
uniform highp vec4 UNIFORM_OUTERCANTHUS_PTS[6];
uniform highp float UNIFORM_OUTERCANTHUS_COEF;
uniform highp vec2 OUTERCANTHUS_PARAM[6];
uniform highp vec2 OUTERCANTHUS_PARAMRADIUS[6];
uniform highp float UNIFORM_EYEBROWCOEF;
uniform highp float UNIFORM_LIPCOEF;
uniform highp float UNIFORM_EYEADCOEF;
uniform highp vec4 EYEBROWPOINTS[4];
uniform highp vec2 EYEBROWPARA[4];
uniform highp vec2 EYEBROWPARARADIUS[4];
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1 = _glesVertex;
  highp vec2 displacement_2;
  highp vec2 face_dir_3;
  highp vec2 positionToUse_4;
  highp float scaleRatio_5;
  highp float eyebrowCoef_6;
  highp float outercanthusCoef_7;
  highp float hairlineCoef_8;
  highp float philtrumCoef_9;
  highp float chinCoef_10;
  highp float noselengthCoef_11;
  highp float noseCoef_12;
  highp float faceCoef_13;
  highp float aspectRatio_14;
  highp vec2 radius_15;
  radius_15 = UNIFORM_RADIUS;
  aspectRatio_14 = UNIFORM_RATIOASPECT;
  faceCoef_13 = UNIFORM_FACECOEF;
  noseCoef_12 = UNIFORM_NOSECOEF;
  noselengthCoef_11 = UNIFORM_NOSELENGTH_COEF;
  chinCoef_10 = UNIFORM_CHINCOEF;
  philtrumCoef_9 = UNIFORM_PHILTRUMCOEF;
  hairlineCoef_8 = UNIFORM_HAIRLINECOEF;
  outercanthusCoef_7 = UNIFORM_OUTERCANTHUS_COEF;
  eyebrowCoef_6 = UNIFORM_EYEBROWCOEF;
  scaleRatio_5 = UNIFORM_SCALERATIO;
  highp vec3 tmpvar_16;
  tmpvar_16.z = 1.0;
  tmpvar_16.xy = tmpvar_1.xy;
  highp vec2 tmpvar_17;
  tmpvar_17 = (tmpvar_16 * UNIFORM_ZOOMSCALE).xy;
  highp vec4 tmpvar_18;
  tmpvar_18.xy = tmpvar_17;
  tmpvar_18.zw = tmpvar_1.zw;
  positionToUse_4 = ((tmpvar_17 + vec2(1.0, 1.0)) - 1.0);
  highp vec2 tmpvar_19;
  tmpvar_19 = (UNIFORM_RIGHT_EYE - UNIFORM_LEFT_EYE);
  highp vec2 tmpvar_20;
  tmpvar_20.x = tmpvar_19.x;
  tmpvar_20.y = (tmpvar_19.y * UNIFORM_RATIOASPECT);
  face_dir_3 = (tmpvar_20 / sqrt(dot (tmpvar_20, tmpvar_20)));
  displacement_2 = vec2(0.0, 0.0);
  highp float tmpvar_21;
  tmpvar_21 = abs(UNIFORM_LIPCOEF);
  if ((tmpvar_21 > 0.001)) {
    for (highp int i_22 = 0; i_22 < 47; i_22++) {
      highp int tmpvar_23;
      tmpvar_23 = int(MOUTHTRIANGLES[i_22].x);
      highp int tmpvar_24;
      tmpvar_24 = int(MOUTHTRIANGLES[i_22].y);
      highp int tmpvar_25;
      tmpvar_25 = int(MOUTHTRIANGLES[i_22].z);
      highp vec2 tmpvar_26;
      highp vec2 tmpvar_27;
      highp vec2 tmpvar_28;
      tmpvar_26 = MOUTHTRIANGLEPOINTSOUECE[tmpvar_23];
      tmpvar_27 = MOUTHTRIANGLEPOINTSOUECE[tmpvar_24];
      tmpvar_28 = MOUTHTRIANGLEPOINTSOUECE[tmpvar_25];
      highp vec2 tmpvar_29;
      highp vec2 tmpvar_30;
      highp vec2 tmpvar_31;
      tmpvar_29 = MOUTHTRIANGLEPOINTTARGET[tmpvar_23];
      tmpvar_30 = MOUTHTRIANGLEPOINTTARGET[tmpvar_24];
      tmpvar_31 = MOUTHTRIANGLEPOINTTARGET[tmpvar_25];
      highp vec2 res_p_32;
      highp vec3 tmpvar_33;
      tmpvar_33.x = tmpvar_29.x;
      tmpvar_33.y = tmpvar_30.x;
      tmpvar_33.z = tmpvar_31.x;
      highp vec3 tmpvar_34;
      tmpvar_34.x = tmpvar_29.y;
      tmpvar_34.y = tmpvar_30.y;
      tmpvar_34.z = tmpvar_31.y;
      highp float tmpvar_35;
      tmpvar_35 = (((tmpvar_30.y - tmpvar_29.y) * (tmpvar_31.x - tmpvar_29.x)) - ((tmpvar_30.x - tmpvar_29.x) * (tmpvar_31.y - tmpvar_29.y)));
      highp float tmpvar_36;
      tmpvar_36 = (((tmpvar_31.y - tmpvar_30.y) * (tmpvar_29.x - tmpvar_30.x)) - ((tmpvar_31.x - tmpvar_30.x) * (tmpvar_29.y - tmpvar_30.y)));
      highp float tmpvar_37;
      tmpvar_37 = (((tmpvar_29.y - tmpvar_31.y) * (tmpvar_30.x - tmpvar_31.x)) - ((tmpvar_29.x - tmpvar_31.x) * (tmpvar_30.y - tmpvar_31.y)));
      highp float tmpvar_38;
      tmpvar_38 = (((tmpvar_30.y - tmpvar_29.y) * (positionToUse_4.x - tmpvar_29.x)) - ((tmpvar_30.x - tmpvar_29.x) * (positionToUse_4.y - tmpvar_29.y)));
      highp float tmpvar_39;
      tmpvar_39 = (((tmpvar_31.y - tmpvar_30.y) * (positionToUse_4.x - tmpvar_30.x)) - ((tmpvar_31.x - tmpvar_30.x) * (positionToUse_4.y - tmpvar_30.y)));
      highp float tmpvar_40;
      tmpvar_40 = (((tmpvar_29.y - tmpvar_31.y) * (positionToUse_4.x - tmpvar_31.x)) - ((tmpvar_29.x - tmpvar_31.x) * (positionToUse_4.y - tmpvar_31.y)));
      res_p_32 = positionToUse_4;
      if ((((
        (tmpvar_35 * tmpvar_38)
       >= 0.0) && (
        (tmpvar_36 * tmpvar_39)
       >= 0.0)) && ((tmpvar_37 * tmpvar_40) >= 0.0))) {
        bool tmpvar_41;
        tmpvar_41 = bool(1);
        highp vec3 tmpvar_42;
        highp vec4 o3_43;
        highp vec4 o2_44;
        highp vec4 o1_45;
        highp vec4 tmpvar_46;
        tmpvar_46.xyz = tmpvar_33;
        tmpvar_46.w = positionToUse_4.x;
        o1_45 = tmpvar_46;
        highp vec4 tmpvar_47;
        tmpvar_47.xyz = tmpvar_34;
        tmpvar_47.w = positionToUse_4.y;
        o2_44 = tmpvar_47;
        o3_43 = vec4(1.0, 1.0, 1.0, 1.0);
        highp float tmpvar_48;
        tmpvar_48 = abs(tmpvar_29.x);
        if ((tmpvar_48 < 1e-5)) {
          o1_45 = (tmpvar_46 + vec4(1.0, 1.0, 1.0, 1.0));
        };
        o1_45 = (o1_45 / o1_45.x);
        o2_44 = (tmpvar_47 - (tmpvar_29.y * o1_45));
        o3_43 = (vec4(1.0, 1.0, 1.0, 1.0) - o1_45);
        highp float tmpvar_49;
        tmpvar_49 = abs(o2_44.y);
        if ((tmpvar_49 < 1e-5)) {
          highp float tmpvar_50;
          tmpvar_50 = abs(o3_43.y);
          if ((tmpvar_50 < 1e-5)) {
            highp float tmpvar_51;
            tmpvar_51 = abs(o2_44.z);
            if ((tmpvar_51 < 1e-5)) {
              tmpvar_42 = vec3(1.0, 0.0, 0.0);
              tmpvar_41 = bool(0);
            } else {
              highp vec3 tmpvar_52;
              tmpvar_52.y = 0.0;
              tmpvar_52.x = o1_45.w;
              tmpvar_52.z = (o2_44.w / o2_44.z);
              tmpvar_42 = tmpvar_52;
              tmpvar_41 = bool(0);
            };
          } else {
            highp vec4 o_temp_53;
            o_temp_53 = o2_44;
            o2_44 = o3_43;
            o3_43 = o_temp_53;
          };
        };
        if (tmpvar_41) {
          o2_44 = (o2_44 / o2_44.y);
          o3_43 = (o3_43 - (o2_44 * o3_43.y));
          highp float tmpvar_54;
          tmpvar_54 = abs(o3_43.z);
          if ((tmpvar_54 > 1e-5)) {
            o3_43 = (o3_43 / o3_43.z);
          } else {
            o3_43.w = 0.0;
          };
          o3_43 = (o3_43 / o3_43.z);
          o2_44 = (o2_44 - (o3_43 * o2_44.z));
          o1_45 = ((o1_45 - (o2_44 * o1_45.y)) - (o3_43 * o1_45.z));
          highp vec3 tmpvar_55;
          tmpvar_55.x = o1_45.w;
          tmpvar_55.y = o2_44.w;
          tmpvar_55.z = o3_43.w;
          tmpvar_42 = tmpvar_55;
          tmpvar_41 = bool(0);
        };
        res_p_32 = (((tmpvar_26 * tmpvar_42.x) + (tmpvar_27 * tmpvar_42.y)) + (tmpvar_28 * tmpvar_42.z));
      };
      displacement_2 = ((displacement_2 + res_p_32) - positionToUse_4);
    };
  };
  highp float tmpvar_56;
  tmpvar_56 = abs(UNIFORM_EYEADCOEF);
  if ((tmpvar_56 > 0.001)) {
    for (highp int i_1_57 = 0; i_1_57 < 22; i_1_57++) {
      highp int tmpvar_58;
      tmpvar_58 = int(UNIFORM_EYEAD_TRIANGLE[i_1_57].x);
      highp int tmpvar_59;
      tmpvar_59 = int(UNIFORM_EYEAD_TRIANGLE[i_1_57].y);
      highp int tmpvar_60;
      tmpvar_60 = int(UNIFORM_EYEAD_TRIANGLE[i_1_57].z);
      highp vec2 tmpvar_61;
      highp vec2 tmpvar_62;
      highp vec2 tmpvar_63;
      tmpvar_61 = UNIFORM_EYEAD_LEFT_FROM[tmpvar_58];
      tmpvar_62 = UNIFORM_EYEAD_LEFT_FROM[tmpvar_59];
      tmpvar_63 = UNIFORM_EYEAD_LEFT_FROM[tmpvar_60];
      highp vec2 tmpvar_64;
      highp vec2 tmpvar_65;
      highp vec2 tmpvar_66;
      tmpvar_64 = UNIFORM_EYEAD_LEFT_TO[tmpvar_58];
      tmpvar_65 = UNIFORM_EYEAD_LEFT_TO[tmpvar_59];
      tmpvar_66 = UNIFORM_EYEAD_LEFT_TO[tmpvar_60];
      highp vec2 res_p_67;
      highp vec3 tmpvar_68;
      tmpvar_68.x = tmpvar_64.x;
      tmpvar_68.y = tmpvar_65.x;
      tmpvar_68.z = tmpvar_66.x;
      highp vec3 tmpvar_69;
      tmpvar_69.x = tmpvar_64.y;
      tmpvar_69.y = tmpvar_65.y;
      tmpvar_69.z = tmpvar_66.y;
      highp float tmpvar_70;
      tmpvar_70 = (((tmpvar_65.y - tmpvar_64.y) * (tmpvar_66.x - tmpvar_64.x)) - ((tmpvar_65.x - tmpvar_64.x) * (tmpvar_66.y - tmpvar_64.y)));
      highp float tmpvar_71;
      tmpvar_71 = (((tmpvar_66.y - tmpvar_65.y) * (tmpvar_64.x - tmpvar_65.x)) - ((tmpvar_66.x - tmpvar_65.x) * (tmpvar_64.y - tmpvar_65.y)));
      highp float tmpvar_72;
      tmpvar_72 = (((tmpvar_64.y - tmpvar_66.y) * (tmpvar_65.x - tmpvar_66.x)) - ((tmpvar_64.x - tmpvar_66.x) * (tmpvar_65.y - tmpvar_66.y)));
      highp float tmpvar_73;
      tmpvar_73 = (((tmpvar_65.y - tmpvar_64.y) * (positionToUse_4.x - tmpvar_64.x)) - ((tmpvar_65.x - tmpvar_64.x) * (positionToUse_4.y - tmpvar_64.y)));
      highp float tmpvar_74;
      tmpvar_74 = (((tmpvar_66.y - tmpvar_65.y) * (positionToUse_4.x - tmpvar_65.x)) - ((tmpvar_66.x - tmpvar_65.x) * (positionToUse_4.y - tmpvar_65.y)));
      highp float tmpvar_75;
      tmpvar_75 = (((tmpvar_64.y - tmpvar_66.y) * (positionToUse_4.x - tmpvar_66.x)) - ((tmpvar_64.x - tmpvar_66.x) * (positionToUse_4.y - tmpvar_66.y)));
      res_p_67 = positionToUse_4;
      if ((((
        (tmpvar_70 * tmpvar_73)
       >= 0.0) && (
        (tmpvar_71 * tmpvar_74)
       >= 0.0)) && ((tmpvar_72 * tmpvar_75) >= 0.0))) {
        bool tmpvar_76;
        tmpvar_76 = bool(1);
        highp vec3 tmpvar_77;
        highp vec4 o3_78;
        highp vec4 o2_79;
        highp vec4 o1_80;
        highp vec4 tmpvar_81;
        tmpvar_81.xyz = tmpvar_68;
        tmpvar_81.w = positionToUse_4.x;
        o1_80 = tmpvar_81;
        highp vec4 tmpvar_82;
        tmpvar_82.xyz = tmpvar_69;
        tmpvar_82.w = positionToUse_4.y;
        o2_79 = tmpvar_82;
        o3_78 = vec4(1.0, 1.0, 1.0, 1.0);
        highp float tmpvar_83;
        tmpvar_83 = abs(tmpvar_64.x);
        if ((tmpvar_83 < 1e-5)) {
          o1_80 = (tmpvar_81 + vec4(1.0, 1.0, 1.0, 1.0));
        };
        o1_80 = (o1_80 / o1_80.x);
        o2_79 = (tmpvar_82 - (tmpvar_64.y * o1_80));
        o3_78 = (vec4(1.0, 1.0, 1.0, 1.0) - o1_80);
        highp float tmpvar_84;
        tmpvar_84 = abs(o2_79.y);
        if ((tmpvar_84 < 1e-5)) {
          highp float tmpvar_85;
          tmpvar_85 = abs(o3_78.y);
          if ((tmpvar_85 < 1e-5)) {
            highp float tmpvar_86;
            tmpvar_86 = abs(o2_79.z);
            if ((tmpvar_86 < 1e-5)) {
              tmpvar_77 = vec3(1.0, 0.0, 0.0);
              tmpvar_76 = bool(0);
            } else {
              highp vec3 tmpvar_87;
              tmpvar_87.y = 0.0;
              tmpvar_87.x = o1_80.w;
              tmpvar_87.z = (o2_79.w / o2_79.z);
              tmpvar_77 = tmpvar_87;
              tmpvar_76 = bool(0);
            };
          } else {
            highp vec4 o_temp_88;
            o_temp_88 = o2_79;
            o2_79 = o3_78;
            o3_78 = o_temp_88;
          };
        };
        if (tmpvar_76) {
          o2_79 = (o2_79 / o2_79.y);
          o3_78 = (o3_78 - (o2_79 * o3_78.y));
          highp float tmpvar_89;
          tmpvar_89 = abs(o3_78.z);
          if ((tmpvar_89 > 1e-5)) {
            o3_78 = (o3_78 / o3_78.z);
          } else {
            o3_78.w = 0.0;
          };
          o3_78 = (o3_78 / o3_78.z);
          o2_79 = (o2_79 - (o3_78 * o2_79.z));
          o1_80 = ((o1_80 - (o2_79 * o1_80.y)) - (o3_78 * o1_80.z));
          highp vec3 tmpvar_90;
          tmpvar_90.x = o1_80.w;
          tmpvar_90.y = o2_79.w;
          tmpvar_90.z = o3_78.w;
          tmpvar_77 = tmpvar_90;
          tmpvar_76 = bool(0);
        };
        res_p_67 = (((tmpvar_61 * tmpvar_77.x) + (tmpvar_62 * tmpvar_77.y)) + (tmpvar_63 * tmpvar_77.z));
      };
      displacement_2 = ((displacement_2 + res_p_67) - positionToUse_4);
      highp vec2 tmpvar_91;
      highp vec2 tmpvar_92;
      highp vec2 tmpvar_93;
      tmpvar_91 = UNIFORM_EYEAD_RIGHT_FROM[tmpvar_58];
      tmpvar_92 = UNIFORM_EYEAD_RIGHT_FROM[tmpvar_59];
      tmpvar_93 = UNIFORM_EYEAD_RIGHT_FROM[tmpvar_60];
      highp vec2 tmpvar_94;
      highp vec2 tmpvar_95;
      highp vec2 tmpvar_96;
      tmpvar_94 = UNIFORM_EYEAD_RIGHT_TO[tmpvar_58];
      tmpvar_95 = UNIFORM_EYEAD_RIGHT_TO[tmpvar_59];
      tmpvar_96 = UNIFORM_EYEAD_RIGHT_TO[tmpvar_60];
      highp vec2 res_p_97;
      highp vec3 tmpvar_98;
      tmpvar_98.x = tmpvar_94.x;
      tmpvar_98.y = tmpvar_95.x;
      tmpvar_98.z = tmpvar_96.x;
      highp vec3 tmpvar_99;
      tmpvar_99.x = tmpvar_94.y;
      tmpvar_99.y = tmpvar_95.y;
      tmpvar_99.z = tmpvar_96.y;
      highp float tmpvar_100;
      tmpvar_100 = (((tmpvar_95.y - tmpvar_94.y) * (tmpvar_96.x - tmpvar_94.x)) - ((tmpvar_95.x - tmpvar_94.x) * (tmpvar_96.y - tmpvar_94.y)));
      highp float tmpvar_101;
      tmpvar_101 = (((tmpvar_96.y - tmpvar_95.y) * (tmpvar_94.x - tmpvar_95.x)) - ((tmpvar_96.x - tmpvar_95.x) * (tmpvar_94.y - tmpvar_95.y)));
      highp float tmpvar_102;
      tmpvar_102 = (((tmpvar_94.y - tmpvar_96.y) * (tmpvar_95.x - tmpvar_96.x)) - ((tmpvar_94.x - tmpvar_96.x) * (tmpvar_95.y - tmpvar_96.y)));
      highp float tmpvar_103;
      tmpvar_103 = (((tmpvar_95.y - tmpvar_94.y) * (positionToUse_4.x - tmpvar_94.x)) - ((tmpvar_95.x - tmpvar_94.x) * (positionToUse_4.y - tmpvar_94.y)));
      highp float tmpvar_104;
      tmpvar_104 = (((tmpvar_96.y - tmpvar_95.y) * (positionToUse_4.x - tmpvar_95.x)) - ((tmpvar_96.x - tmpvar_95.x) * (positionToUse_4.y - tmpvar_95.y)));
      highp float tmpvar_105;
      tmpvar_105 = (((tmpvar_94.y - tmpvar_96.y) * (positionToUse_4.x - tmpvar_96.x)) - ((tmpvar_94.x - tmpvar_96.x) * (positionToUse_4.y - tmpvar_96.y)));
      res_p_97 = positionToUse_4;
      if ((((
        (tmpvar_100 * tmpvar_103)
       >= 0.0) && (
        (tmpvar_101 * tmpvar_104)
       >= 0.0)) && ((tmpvar_102 * tmpvar_105) >= 0.0))) {
        bool tmpvar_106;
        tmpvar_106 = bool(1);
        highp vec3 tmpvar_107;
        highp vec4 o3_108;
        highp vec4 o2_109;
        highp vec4 o1_110;
        highp vec4 tmpvar_111;
        tmpvar_111.xyz = tmpvar_98;
        tmpvar_111.w = positionToUse_4.x;
        o1_110 = tmpvar_111;
        highp vec4 tmpvar_112;
        tmpvar_112.xyz = tmpvar_99;
        tmpvar_112.w = positionToUse_4.y;
        o2_109 = tmpvar_112;
        o3_108 = vec4(1.0, 1.0, 1.0, 1.0);
        highp float tmpvar_113;
        tmpvar_113 = abs(tmpvar_94.x);
        if ((tmpvar_113 < 1e-5)) {
          o1_110 = (tmpvar_111 + vec4(1.0, 1.0, 1.0, 1.0));
        };
        o1_110 = (o1_110 / o1_110.x);
        o2_109 = (tmpvar_112 - (tmpvar_94.y * o1_110));
        o3_108 = (vec4(1.0, 1.0, 1.0, 1.0) - o1_110);
        highp float tmpvar_114;
        tmpvar_114 = abs(o2_109.y);
        if ((tmpvar_114 < 1e-5)) {
          highp float tmpvar_115;
          tmpvar_115 = abs(o3_108.y);
          if ((tmpvar_115 < 1e-5)) {
            highp float tmpvar_116;
            tmpvar_116 = abs(o2_109.z);
            if ((tmpvar_116 < 1e-5)) {
              tmpvar_107 = vec3(1.0, 0.0, 0.0);
              tmpvar_106 = bool(0);
            } else {
              highp vec3 tmpvar_117;
              tmpvar_117.y = 0.0;
              tmpvar_117.x = o1_110.w;
              tmpvar_117.z = (o2_109.w / o2_109.z);
              tmpvar_107 = tmpvar_117;
              tmpvar_106 = bool(0);
            };
          } else {
            highp vec4 o_temp_118;
            o_temp_118 = o2_109;
            o2_109 = o3_108;
            o3_108 = o_temp_118;
          };
        };
        if (tmpvar_106) {
          o2_109 = (o2_109 / o2_109.y);
          o3_108 = (o3_108 - (o2_109 * o3_108.y));
          highp float tmpvar_119;
          tmpvar_119 = abs(o3_108.z);
          if ((tmpvar_119 > 1e-5)) {
            o3_108 = (o3_108 / o3_108.z);
          } else {
            o3_108.w = 0.0;
          };
          o3_108 = (o3_108 / o3_108.z);
          o2_109 = (o2_109 - (o3_108 * o2_109.z));
          o1_110 = ((o1_110 - (o2_109 * o1_110.y)) - (o3_108 * o1_110.z));
          highp vec3 tmpvar_120;
          tmpvar_120.x = o1_110.w;
          tmpvar_120.y = o2_109.w;
          tmpvar_120.z = o3_108.w;
          tmpvar_107 = tmpvar_120;
          tmpvar_106 = bool(0);
        };
        res_p_97 = (((tmpvar_91 * tmpvar_107.x) + (tmpvar_92 * tmpvar_107.y)) + (tmpvar_93 * tmpvar_107.z));
      };
      displacement_2 = ((displacement_2 + res_p_97) - positionToUse_4);
    };
  };
  if ((UNIFORM_SCALERATIO > 0.001)) {
    if ((UNIFORM_LIKEEVERSION > 0.0)) {
      highp float scaleRatio_121;
      scaleRatio_121 = (0.7 * UNIFORM_SCALERATIO);
      highp vec2 tmpvar_122;
      highp vec2 tmpvar_123;
      tmpvar_123.x = positionToUse_4.x;
      tmpvar_123.y = (positionToUse_4.y * UNIFORM_RATIOASPECT);
      highp vec2 tmpvar_124;
      tmpvar_124.x = UNIFORM_LEFT_EYE.x;
      tmpvar_124.y = (UNIFORM_LEFT_EYE.y * UNIFORM_RATIOASPECT);
      highp vec2 tmpvar_125;
      tmpvar_125 = (tmpvar_123 - tmpvar_124);
      highp float tmpvar_126;
      tmpvar_126 = dot (tmpvar_125, tmpvar_125);
      highp float tmpvar_127;
      tmpvar_127 = (UNIFORM_RADIUS.x * UNIFORM_RADIUS.x);
      if ((tmpvar_126 > tmpvar_127)) {
        tmpvar_122 = positionToUse_4;
      } else {
        highp float tmpvar_128;
        tmpvar_128 = ((sqrt(tmpvar_126) / UNIFORM_RADIUS.x) - 1.0);
        tmpvar_122 = (UNIFORM_LEFT_EYE + ((1.0 - 
          ((scaleRatio_121 * tmpvar_128) * tmpvar_128)
        ) * (positionToUse_4 - UNIFORM_LEFT_EYE)));
      };
      displacement_2 = ((displacement_2 + tmpvar_122) - positionToUse_4);
      highp float scaleRatio_129;
      scaleRatio_129 = (0.7 * UNIFORM_SCALERATIO);
      highp vec2 tmpvar_130;
      highp vec2 tmpvar_131;
      tmpvar_131.x = positionToUse_4.x;
      tmpvar_131.y = (positionToUse_4.y * UNIFORM_RATIOASPECT);
      highp vec2 tmpvar_132;
      tmpvar_132.x = UNIFORM_RIGHT_EYE.x;
      tmpvar_132.y = (UNIFORM_RIGHT_EYE.y * UNIFORM_RATIOASPECT);
      highp vec2 tmpvar_133;
      tmpvar_133 = (tmpvar_131 - tmpvar_132);
      highp float tmpvar_134;
      tmpvar_134 = dot (tmpvar_133, tmpvar_133);
      highp float tmpvar_135;
      tmpvar_135 = (UNIFORM_RADIUS.y * UNIFORM_RADIUS.y);
      if ((tmpvar_134 > tmpvar_135)) {
        tmpvar_130 = positionToUse_4;
      } else {
        highp float tmpvar_136;
        tmpvar_136 = ((sqrt(tmpvar_134) / UNIFORM_RADIUS.y) - 1.0);
        tmpvar_130 = (UNIFORM_RIGHT_EYE + ((1.0 - 
          ((scaleRatio_129 * tmpvar_136) * tmpvar_136)
        ) * (positionToUse_4 - UNIFORM_RIGHT_EYE)));
      };
      displacement_2 = ((displacement_2 + tmpvar_130) - positionToUse_4);
    } else {
      for (highp int j_137 = 0; j_137 < 2; j_137++) {
        highp vec2 tmpvar_138;
        tmpvar_138 = (EYECORNERPOINTS[((j_137 * 4) + 3)] - EYECORNERPOINTS[((j_137 * 4) + 2)]);
        highp vec2 tmpvar_139;
        tmpvar_139 = (EYECORNERPOINTS[(j_137 * 4)] - EYECORNERPOINTS[((j_137 * 4) + 1)]);
        highp float tmpvar_140;
        tmpvar_140 = ((sqrt(
          dot (tmpvar_138, tmpvar_138)
        ) / sqrt(
          dot (tmpvar_139, tmpvar_139)
        )) / aspectRatio_14);
        highp float tmpvar_141;
        tmpvar_141 = (sqrt(dot (tmpvar_138, tmpvar_138)) * aspectRatio_14);
        highp float tmpvar_142;
        tmpvar_142 = (tmpvar_141 * radius_15.y);
        highp float tmpvar_143;
        tmpvar_143 = (tmpvar_141 * radius_15.x);
        highp vec2 tmpvar_144;
        tmpvar_144 = (((
          (EYECORNERPOINTS[(j_137 * 4)] + EYECORNERPOINTS[((j_137 * 4) + 1)])
         + EYECORNERPOINTS[
          ((j_137 * 4) + 2)
        ]) + EYECORNERPOINTS[(
          (j_137 * 4)
         + 3)]) / 4.0);
        highp vec2 m_point_145;
        highp vec2 tmpvar_146;
        tmpvar_146.x = -(face_dir_3.y);
        tmpvar_146.y = face_dir_3.x;
        m_point_145 = positionToUse_4;
        highp vec2 tmpvar_147;
        tmpvar_147.x = positionToUse_4.x;
        tmpvar_147.y = (((positionToUse_4.y * aspectRatio_14) + 0.5) - ((0.5 * aspectRatio_14) * tmpvar_140));
        highp vec2 tmpvar_148;
        tmpvar_148.x = tmpvar_144.x;
        tmpvar_148.y = (((tmpvar_144.y * aspectRatio_14) + 0.5) - ((0.5 * aspectRatio_14) * tmpvar_140));
        highp vec2 tmpvar_149;
        tmpvar_149 = (tmpvar_147 - tmpvar_148);
        highp float tmpvar_150;
        tmpvar_150 = dot (tmpvar_149, face_dir_3);
        highp float tmpvar_151;
        tmpvar_151 = dot (tmpvar_149, tmpvar_146);
        highp float tmpvar_152;
        tmpvar_152 = sqrt(((tmpvar_150 * tmpvar_150) + (
          (tmpvar_151 * tmpvar_151)
         * 
          (tmpvar_140 * tmpvar_140)
        )));
        highp float tmpvar_153;
        tmpvar_153 = (((tmpvar_143 - tmpvar_142) / tmpvar_142) * (0.4 * scaleRatio_5));
        highp float tmpvar_154;
        tmpvar_154 = (tmpvar_142 * (1.0 + tmpvar_153));
        if ((tmpvar_152 < tmpvar_154)) {
          m_point_145 = (tmpvar_144 + ((positionToUse_4 - tmpvar_144) * (1.0/(
            (1.0 + tmpvar_153)
          ))));
        } else {
          if ((tmpvar_152 < tmpvar_143)) {
            m_point_145 = (tmpvar_144 + ((
              (positionToUse_4 - tmpvar_144)
             * 
              (tmpvar_143 - (((tmpvar_143 - tmpvar_152) / (tmpvar_143 - tmpvar_154)) * (tmpvar_143 - tmpvar_142)))
            ) / tmpvar_152));
          };
        };
        displacement_2 = ((displacement_2 + m_point_145) - positionToUse_4);
      };
    };
  };
  if ((UNIFORM_HAIRLINECOEF > 0.001)) {
    for (highp int j_1_155 = 0; j_1_155 < 9; j_1_155++) {
      highp vec2 src_156;
      src_156 = HAIRLINEPOINTS[j_1_155].xy;
      highp vec2 dst_157;
      dst_157 = HAIRLINEPOINTS[j_1_155].zw;
      highp float radiusFactor_158;
      radiusFactor_158 = HAIRLINEPARARADIUS[j_1_155].x;
      highp float deltaFactorX_159;
      deltaFactorX_159 = (HAIRLINEPARA[j_1_155].x * hairlineCoef_8);
      highp float deltaFactorY_160;
      deltaFactorY_160 = (HAIRLINEPARA[j_1_155].y * hairlineCoef_8);
      highp vec2 tmpvar_161;
      highp vec2 positionToUse_162;
      highp float alpha_163;
      highp vec2 dir_164;
      highp float tmpvar_165;
      tmpvar_165 = sqrt(((deltaFactorX_159 * deltaFactorX_159) + (
        (deltaFactorY_160 * deltaFactorY_160)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_166;
      tmpvar_166.x = positionToUse_4.x;
      tmpvar_166.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_167;
      tmpvar_167.x = src_156.x;
      tmpvar_167.y = (src_156.y * aspectRatio_14);
      highp vec2 tmpvar_168;
      tmpvar_168.x = dst_157.x;
      tmpvar_168.y = (dst_157.y * aspectRatio_14);
      highp vec2 tmpvar_169;
      tmpvar_169 = (tmpvar_166 - tmpvar_167);
      highp float tmpvar_170;
      tmpvar_170 = dot (tmpvar_169, tmpvar_169);
      highp vec2 tmpvar_171;
      tmpvar_171 = (tmpvar_168 - tmpvar_167);
      dir_164.x = tmpvar_171.x;
      dir_164.y = (tmpvar_171.y / 1.765);
      highp float tmpvar_172;
      tmpvar_172 = dot (dir_164, dir_164);
      highp float tmpvar_173;
      tmpvar_173 = ((radiusFactor_158 * radiusFactor_158) * tmpvar_172);
      if ((tmpvar_170 > tmpvar_173)) {
        tmpvar_161 = positionToUse_4;
      } else {
        highp float tmpvar_174;
        tmpvar_174 = sqrt(tmpvar_172);
        dir_164 = (dir_164 / tmpvar_174);
        highp float tmpvar_175;
        tmpvar_175 = (tmpvar_173 - tmpvar_170);
        highp float tmpvar_176;
        tmpvar_176 = (tmpvar_165 * tmpvar_174);
        highp float tmpvar_177;
        tmpvar_177 = (sqrt(tmpvar_170) - tmpvar_176);
        highp float tmpvar_178;
        tmpvar_178 = (tmpvar_175 / (tmpvar_175 + (tmpvar_177 * tmpvar_177)));
        alpha_163 = (tmpvar_178 * tmpvar_178);
        highp vec2 tmpvar_179;
        tmpvar_179 = (dot (dir_164, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_180;
        tmpvar_180 = (-((
          ((alpha_163 * tmpvar_176) / (tmpvar_165 + 0.0001))
         * deltaFactorX_159)) * tmpvar_179);
        highp vec2 tmpvar_181;
        tmpvar_181 = (-((
          ((alpha_163 * tmpvar_176) / (tmpvar_165 + 0.0001))
         * deltaFactorY_160)) * (dir_164 - tmpvar_179));
        positionToUse_162.x = ((positionToUse_4.x + tmpvar_180.x) + tmpvar_181.x);
        positionToUse_162.y = (positionToUse_4.y + ((
          (tmpvar_180.y + tmpvar_181.y)
         / aspectRatio_14) * 1.765));
        tmpvar_161 = positionToUse_162;
      };
      displacement_2 = ((displacement_2 + tmpvar_161) - positionToUse_4);
    };
  };
  if ((UNIFORM_FACECOEF > 0.001)) {
    for (highp int j_2_182 = 0; j_2_182 < 42; j_2_182++) {
      highp vec2 src_183;
      src_183 = UNIFORM_PTS[j_2_182].xy;
      highp vec2 dst_184;
      dst_184 = UNIFORM_PTS[j_2_182].zw;
      highp float radiusFactor_185;
      radiusFactor_185 = FACEPARARADIUS[j_2_182].x;
      highp float deltaFactorX_186;
      deltaFactorX_186 = (FACEPARA[j_2_182].x * faceCoef_13);
      highp float deltaFactorY_187;
      deltaFactorY_187 = (FACEPARA[j_2_182].y * faceCoef_13);
      highp vec2 tmpvar_188;
      highp vec2 positionToUse_189;
      highp float alpha_190;
      highp vec2 dir_191;
      highp float tmpvar_192;
      tmpvar_192 = sqrt(((deltaFactorX_186 * deltaFactorX_186) + (
        (deltaFactorY_187 * deltaFactorY_187)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_193;
      tmpvar_193.x = positionToUse_4.x;
      tmpvar_193.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_194;
      tmpvar_194.x = src_183.x;
      tmpvar_194.y = (src_183.y * aspectRatio_14);
      highp vec2 tmpvar_195;
      tmpvar_195.x = dst_184.x;
      tmpvar_195.y = (dst_184.y * aspectRatio_14);
      highp vec2 tmpvar_196;
      tmpvar_196 = (tmpvar_193 - tmpvar_194);
      highp float tmpvar_197;
      tmpvar_197 = dot (tmpvar_196, tmpvar_196);
      highp vec2 tmpvar_198;
      tmpvar_198 = (tmpvar_195 - tmpvar_194);
      dir_191.x = tmpvar_198.x;
      dir_191.y = (tmpvar_198.y / 1.765);
      highp float tmpvar_199;
      tmpvar_199 = dot (dir_191, dir_191);
      highp float tmpvar_200;
      tmpvar_200 = ((radiusFactor_185 * radiusFactor_185) * tmpvar_199);
      if ((tmpvar_197 > tmpvar_200)) {
        tmpvar_188 = positionToUse_4;
      } else {
        highp float tmpvar_201;
        tmpvar_201 = sqrt(tmpvar_199);
        dir_191 = (dir_191 / tmpvar_201);
        highp float tmpvar_202;
        tmpvar_202 = (tmpvar_200 - tmpvar_197);
        highp float tmpvar_203;
        tmpvar_203 = (tmpvar_192 * tmpvar_201);
        highp float tmpvar_204;
        tmpvar_204 = (sqrt(tmpvar_197) - tmpvar_203);
        highp float tmpvar_205;
        tmpvar_205 = (tmpvar_202 / (tmpvar_202 + (tmpvar_204 * tmpvar_204)));
        alpha_190 = (tmpvar_205 * tmpvar_205);
        highp vec2 tmpvar_206;
        tmpvar_206 = (dot (dir_191, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_207;
        tmpvar_207 = (-((
          ((alpha_190 * tmpvar_203) / (tmpvar_192 + 0.0001))
         * deltaFactorX_186)) * tmpvar_206);
        highp vec2 tmpvar_208;
        tmpvar_208 = (-((
          ((alpha_190 * tmpvar_203) / (tmpvar_192 + 0.0001))
         * deltaFactorY_187)) * (dir_191 - tmpvar_206));
        positionToUse_189.x = ((positionToUse_4.x + tmpvar_207.x) + tmpvar_208.x);
        positionToUse_189.y = (positionToUse_4.y + ((
          (tmpvar_207.y + tmpvar_208.y)
         / aspectRatio_14) * 1.765));
        tmpvar_188 = positionToUse_189;
      };
      displacement_2 = ((displacement_2 + tmpvar_188) - positionToUse_4);
    };
  };
  if ((UNIFORM_CHINCOEF > 0.001)) {
    for (highp int j_3_209 = 0; j_3_209 < 9; j_3_209++) {
      highp vec2 src_210;
      src_210 = CHINPOINTS[j_3_209].xy;
      highp vec2 dst_211;
      dst_211 = CHINPOINTS[j_3_209].zw;
      highp float radiusFactor_212;
      radiusFactor_212 = CHINPARARADIUS[j_3_209].x;
      highp float deltaFactorX_213;
      deltaFactorX_213 = (CHINPARA[j_3_209].x * chinCoef_10);
      highp float deltaFactorY_214;
      deltaFactorY_214 = (CHINPARA[j_3_209].y * chinCoef_10);
      highp vec2 tmpvar_215;
      highp vec2 positionToUse_216;
      highp float alpha_217;
      highp vec2 dir_218;
      highp float tmpvar_219;
      tmpvar_219 = sqrt(((deltaFactorX_213 * deltaFactorX_213) + (
        (deltaFactorY_214 * deltaFactorY_214)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_220;
      tmpvar_220.x = positionToUse_4.x;
      tmpvar_220.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_221;
      tmpvar_221.x = src_210.x;
      tmpvar_221.y = (src_210.y * aspectRatio_14);
      highp vec2 tmpvar_222;
      tmpvar_222.x = dst_211.x;
      tmpvar_222.y = (dst_211.y * aspectRatio_14);
      highp vec2 tmpvar_223;
      tmpvar_223 = (tmpvar_220 - tmpvar_221);
      highp float tmpvar_224;
      tmpvar_224 = dot (tmpvar_223, tmpvar_223);
      highp vec2 tmpvar_225;
      tmpvar_225 = (tmpvar_222 - tmpvar_221);
      dir_218.x = tmpvar_225.x;
      dir_218.y = (tmpvar_225.y / 1.765);
      highp float tmpvar_226;
      tmpvar_226 = dot (dir_218, dir_218);
      highp float tmpvar_227;
      tmpvar_227 = ((radiusFactor_212 * radiusFactor_212) * tmpvar_226);
      if ((tmpvar_224 > tmpvar_227)) {
        tmpvar_215 = positionToUse_4;
      } else {
        highp float tmpvar_228;
        tmpvar_228 = sqrt(tmpvar_226);
        dir_218 = (dir_218 / tmpvar_228);
        highp float tmpvar_229;
        tmpvar_229 = (tmpvar_227 - tmpvar_224);
        highp float tmpvar_230;
        tmpvar_230 = (tmpvar_219 * tmpvar_228);
        highp float tmpvar_231;
        tmpvar_231 = (sqrt(tmpvar_224) - tmpvar_230);
        highp float tmpvar_232;
        tmpvar_232 = (tmpvar_229 / (tmpvar_229 + (tmpvar_231 * tmpvar_231)));
        alpha_217 = (tmpvar_232 * tmpvar_232);
        highp vec2 tmpvar_233;
        tmpvar_233 = (dot (dir_218, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_234;
        tmpvar_234 = (-((
          ((alpha_217 * tmpvar_230) / (tmpvar_219 + 0.0001))
         * deltaFactorX_213)) * tmpvar_233);
        highp vec2 tmpvar_235;
        tmpvar_235 = (-((
          ((alpha_217 * tmpvar_230) / (tmpvar_219 + 0.0001))
         * deltaFactorY_214)) * (dir_218 - tmpvar_233));
        positionToUse_216.x = ((positionToUse_4.x + tmpvar_234.x) + tmpvar_235.x);
        positionToUse_216.y = (positionToUse_4.y + ((
          (tmpvar_234.y + tmpvar_235.y)
         / aspectRatio_14) * 1.765));
        tmpvar_215 = positionToUse_216;
      };
      displacement_2 = ((displacement_2 + tmpvar_215) - positionToUse_4);
    };
  };
  if ((UNIFORM_NOSECOEF > 0.001)) {
    for (highp int j_4_236 = 0; j_4_236 < 4; j_4_236++) {
      highp vec2 src_237;
      src_237 = NOSEPOINTS[j_4_236].xy;
      highp vec2 dst_238;
      dst_238 = NOSEPOINTS[j_4_236].zw;
      highp float radiusFactor_239;
      radiusFactor_239 = NOSEPARAMS[j_4_236].y;
      highp float deltaFactorX_240;
      deltaFactorX_240 = (NOSEPARAMS[j_4_236].x * noseCoef_12);
      highp vec2 tmpvar_241;
      highp vec2 positionToUse_242;
      highp vec2 dir_243;
      highp float tmpvar_244;
      tmpvar_244 = sqrt((deltaFactorX_240 * deltaFactorX_240));
      highp vec2 tmpvar_245;
      tmpvar_245.x = positionToUse_4.x;
      tmpvar_245.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_246;
      tmpvar_246.x = src_237.x;
      tmpvar_246.y = (src_237.y * aspectRatio_14);
      highp vec2 tmpvar_247;
      tmpvar_247.x = dst_238.x;
      tmpvar_247.y = (dst_238.y * aspectRatio_14);
      highp vec2 tmpvar_248;
      tmpvar_248 = (tmpvar_245 - tmpvar_246);
      highp float tmpvar_249;
      tmpvar_249 = dot (tmpvar_248, tmpvar_248);
      highp vec2 tmpvar_250;
      tmpvar_250 = (tmpvar_247 - tmpvar_246);
      dir_243.x = tmpvar_250.x;
      dir_243.y = (tmpvar_250.y / 1.765);
      highp float tmpvar_251;
      tmpvar_251 = dot (dir_243, dir_243);
      highp float tmpvar_252;
      tmpvar_252 = ((radiusFactor_239 * radiusFactor_239) * tmpvar_251);
      if ((tmpvar_249 > tmpvar_252)) {
        tmpvar_241 = positionToUse_4;
      } else {
        highp float tmpvar_253;
        tmpvar_253 = sqrt(tmpvar_251);
        dir_243 = (dir_243 / tmpvar_253);
        highp float tmpvar_254;
        tmpvar_254 = (tmpvar_252 - tmpvar_249);
        highp float tmpvar_255;
        tmpvar_255 = (tmpvar_244 * tmpvar_253);
        highp float tmpvar_256;
        tmpvar_256 = (sqrt(tmpvar_249) - tmpvar_255);
        highp float tmpvar_257;
        tmpvar_257 = (tmpvar_254 / (tmpvar_254 + (tmpvar_256 * tmpvar_256)));
        highp vec2 tmpvar_258;
        tmpvar_258 = (-((
          (((tmpvar_257 * tmpvar_257) * tmpvar_255) / (tmpvar_244 + 0.0001))
         * deltaFactorX_240)) * (dot (dir_243, face_dir_3) * face_dir_3));
        positionToUse_242.x = (positionToUse_4.x + tmpvar_258.x);
        positionToUse_242.y = (positionToUse_4.y + ((tmpvar_258.y / aspectRatio_14) * 1.765));
        tmpvar_241 = positionToUse_242;
      };
      displacement_2 = ((displacement_2 + tmpvar_241) - positionToUse_4);
    };
  };
  if ((UNIFORM_NOSELENGTH_COEF > 0.001)) {
    for (highp int j_5_259 = 0; j_5_259 < 9; j_5_259++) {
      highp vec2 src_260;
      src_260 = UNIFORM_NOSELENGTH_PTS[j_5_259].xy;
      highp vec2 dst_261;
      dst_261 = UNIFORM_NOSELENGTH_PTS[j_5_259].zw;
      highp float radiusFactor_262;
      radiusFactor_262 = NOSELENGTH_PARAMRADIUS[j_5_259].x;
      highp float deltaFactorX_263;
      deltaFactorX_263 = (NOSELENGTH_PARAM[j_5_259].x * noselengthCoef_11);
      highp float deltaFactorY_264;
      deltaFactorY_264 = (NOSELENGTH_PARAM[j_5_259].y * noselengthCoef_11);
      highp vec2 tmpvar_265;
      highp vec2 positionToUse_266;
      highp float alpha_267;
      highp vec2 dir_268;
      highp float tmpvar_269;
      tmpvar_269 = sqrt(((deltaFactorX_263 * deltaFactorX_263) + (
        (deltaFactorY_264 * deltaFactorY_264)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_270;
      tmpvar_270.x = positionToUse_4.x;
      tmpvar_270.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_271;
      tmpvar_271.x = src_260.x;
      tmpvar_271.y = (src_260.y * aspectRatio_14);
      highp vec2 tmpvar_272;
      tmpvar_272.x = dst_261.x;
      tmpvar_272.y = (dst_261.y * aspectRatio_14);
      highp vec2 tmpvar_273;
      tmpvar_273 = (tmpvar_270 - tmpvar_271);
      highp float tmpvar_274;
      tmpvar_274 = dot (tmpvar_273, tmpvar_273);
      highp vec2 tmpvar_275;
      tmpvar_275 = (tmpvar_272 - tmpvar_271);
      dir_268.x = tmpvar_275.x;
      dir_268.y = (tmpvar_275.y / 1.765);
      highp float tmpvar_276;
      tmpvar_276 = dot (dir_268, dir_268);
      highp float tmpvar_277;
      tmpvar_277 = ((radiusFactor_262 * radiusFactor_262) * tmpvar_276);
      if ((tmpvar_274 > tmpvar_277)) {
        tmpvar_265 = positionToUse_4;
      } else {
        highp float tmpvar_278;
        tmpvar_278 = sqrt(tmpvar_276);
        dir_268 = (dir_268 / tmpvar_278);
        highp float tmpvar_279;
        tmpvar_279 = (tmpvar_277 - tmpvar_274);
        highp float tmpvar_280;
        tmpvar_280 = (tmpvar_269 * tmpvar_278);
        highp float tmpvar_281;
        tmpvar_281 = (sqrt(tmpvar_274) - tmpvar_280);
        highp float tmpvar_282;
        tmpvar_282 = (tmpvar_279 / (tmpvar_279 + (tmpvar_281 * tmpvar_281)));
        alpha_267 = (tmpvar_282 * tmpvar_282);
        highp vec2 tmpvar_283;
        tmpvar_283 = (dot (dir_268, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_284;
        tmpvar_284 = (-((
          ((alpha_267 * tmpvar_280) / (tmpvar_269 + 0.0001))
         * deltaFactorX_263)) * tmpvar_283);
        highp vec2 tmpvar_285;
        tmpvar_285 = (-((
          ((alpha_267 * tmpvar_280) / (tmpvar_269 + 0.0001))
         * deltaFactorY_264)) * (dir_268 - tmpvar_283));
        positionToUse_266.x = ((positionToUse_4.x + tmpvar_284.x) + tmpvar_285.x);
        positionToUse_266.y = (positionToUse_4.y + ((
          (tmpvar_284.y + tmpvar_285.y)
         / aspectRatio_14) * 1.765));
        tmpvar_265 = positionToUse_266;
      };
      displacement_2 = ((displacement_2 + tmpvar_265) - positionToUse_4);
    };
  };
  if ((UNIFORM_INNERCANTHUS_COEF > 0.001)) {
    highp vec2 src_286;
    src_286 = UNIFORM_INNERCANTHUS_PTS[0].xy;
    highp vec2 dst_287;
    dst_287 = UNIFORM_INNERCANTHUS_PTS[0].zw;
    highp float radiusFactor_288;
    radiusFactor_288 = INNERCANTHUS_PARAMRADIUS[0].x;
    highp float deltaFactorX_289;
    deltaFactorX_289 = (INNERCANTHUS_PARAM[0].x * UNIFORM_INNERCANTHUS_COEF);
    highp float deltaFactorY_290;
    deltaFactorY_290 = (INNERCANTHUS_PARAM[0].y * UNIFORM_INNERCANTHUS_COEF);
    highp vec2 tmpvar_291;
    highp vec2 positionToUse_292;
    highp float alpha_293;
    highp vec2 dir_294;
    highp float tmpvar_295;
    tmpvar_295 = sqrt(((deltaFactorX_289 * deltaFactorX_289) + (
      (deltaFactorY_290 * deltaFactorY_290)
     * 
      (UNIFORM_RATIOASPECT * UNIFORM_RATIOASPECT)
    )));
    highp vec2 tmpvar_296;
    tmpvar_296.x = positionToUse_4.x;
    tmpvar_296.y = (positionToUse_4.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_297;
    tmpvar_297.x = src_286.x;
    tmpvar_297.y = (src_286.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_298;
    tmpvar_298.x = dst_287.x;
    tmpvar_298.y = (dst_287.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_299;
    tmpvar_299 = (tmpvar_296 - tmpvar_297);
    highp float tmpvar_300;
    tmpvar_300 = dot (tmpvar_299, tmpvar_299);
    highp vec2 tmpvar_301;
    tmpvar_301 = (tmpvar_298 - tmpvar_297);
    dir_294.x = tmpvar_301.x;
    dir_294.y = (tmpvar_301.y / 1.765);
    highp float tmpvar_302;
    tmpvar_302 = dot (dir_294, dir_294);
    highp float tmpvar_303;
    tmpvar_303 = ((radiusFactor_288 * radiusFactor_288) * tmpvar_302);
    if ((tmpvar_300 > tmpvar_303)) {
      tmpvar_291 = positionToUse_4;
    } else {
      highp float tmpvar_304;
      tmpvar_304 = sqrt(tmpvar_302);
      dir_294 = (dir_294 / tmpvar_304);
      highp float tmpvar_305;
      tmpvar_305 = (tmpvar_303 - tmpvar_300);
      highp float tmpvar_306;
      tmpvar_306 = (tmpvar_295 * tmpvar_304);
      highp float tmpvar_307;
      tmpvar_307 = (sqrt(tmpvar_300) - tmpvar_306);
      highp float tmpvar_308;
      tmpvar_308 = (tmpvar_305 / (tmpvar_305 + (tmpvar_307 * tmpvar_307)));
      alpha_293 = (tmpvar_308 * tmpvar_308);
      highp vec2 tmpvar_309;
      tmpvar_309 = (dot (dir_294, face_dir_3) * face_dir_3);
      highp vec2 tmpvar_310;
      tmpvar_310 = (-((
        ((alpha_293 * tmpvar_306) / (tmpvar_295 + 0.0001))
       * deltaFactorX_289)) * tmpvar_309);
      highp vec2 tmpvar_311;
      tmpvar_311 = (-((
        ((alpha_293 * tmpvar_306) / (tmpvar_295 + 0.0001))
       * deltaFactorY_290)) * (dir_294 - tmpvar_309));
      positionToUse_292.x = ((positionToUse_4.x + tmpvar_310.x) + tmpvar_311.x);
      positionToUse_292.y = (positionToUse_4.y + ((
        (tmpvar_310.y + tmpvar_311.y)
       / UNIFORM_RATIOASPECT) * 1.765));
      tmpvar_291 = positionToUse_292;
    };
    displacement_2 = ((displacement_2 + tmpvar_291) - positionToUse_4);
    highp vec2 src_312;
    src_312 = UNIFORM_INNERCANTHUS_PTS[1].xy;
    highp vec2 dst_313;
    dst_313 = UNIFORM_INNERCANTHUS_PTS[1].zw;
    highp float radiusFactor_314;
    radiusFactor_314 = INNERCANTHUS_PARAMRADIUS[1].x;
    highp float deltaFactorX_315;
    deltaFactorX_315 = (INNERCANTHUS_PARAM[1].x * UNIFORM_INNERCANTHUS_COEF);
    highp float deltaFactorY_316;
    deltaFactorY_316 = (INNERCANTHUS_PARAM[1].y * UNIFORM_INNERCANTHUS_COEF);
    highp vec2 tmpvar_317;
    highp vec2 positionToUse_318;
    highp float alpha_319;
    highp vec2 dir_320;
    highp float tmpvar_321;
    tmpvar_321 = sqrt(((deltaFactorX_315 * deltaFactorX_315) + (
      (deltaFactorY_316 * deltaFactorY_316)
     * 
      (UNIFORM_RATIOASPECT * UNIFORM_RATIOASPECT)
    )));
    highp vec2 tmpvar_322;
    tmpvar_322.x = positionToUse_4.x;
    tmpvar_322.y = (positionToUse_4.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_323;
    tmpvar_323.x = src_312.x;
    tmpvar_323.y = (src_312.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_324;
    tmpvar_324.x = dst_313.x;
    tmpvar_324.y = (dst_313.y * UNIFORM_RATIOASPECT);
    highp vec2 tmpvar_325;
    tmpvar_325 = (tmpvar_322 - tmpvar_323);
    highp float tmpvar_326;
    tmpvar_326 = dot (tmpvar_325, tmpvar_325);
    highp vec2 tmpvar_327;
    tmpvar_327 = (tmpvar_324 - tmpvar_323);
    dir_320.x = tmpvar_327.x;
    dir_320.y = (tmpvar_327.y / 1.765);
    highp float tmpvar_328;
    tmpvar_328 = dot (dir_320, dir_320);
    highp float tmpvar_329;
    tmpvar_329 = ((radiusFactor_314 * radiusFactor_314) * tmpvar_328);
    if ((tmpvar_326 > tmpvar_329)) {
      tmpvar_317 = positionToUse_4;
    } else {
      highp float tmpvar_330;
      tmpvar_330 = sqrt(tmpvar_328);
      dir_320 = (dir_320 / tmpvar_330);
      highp float tmpvar_331;
      tmpvar_331 = (tmpvar_329 - tmpvar_326);
      highp float tmpvar_332;
      tmpvar_332 = (tmpvar_321 * tmpvar_330);
      highp float tmpvar_333;
      tmpvar_333 = (sqrt(tmpvar_326) - tmpvar_332);
      highp float tmpvar_334;
      tmpvar_334 = (tmpvar_331 / (tmpvar_331 + (tmpvar_333 * tmpvar_333)));
      alpha_319 = (tmpvar_334 * tmpvar_334);
      highp vec2 tmpvar_335;
      tmpvar_335 = (dot (dir_320, face_dir_3) * face_dir_3);
      highp vec2 tmpvar_336;
      tmpvar_336 = (-((
        ((alpha_319 * tmpvar_332) / (tmpvar_321 + 0.0001))
       * deltaFactorX_315)) * tmpvar_335);
      highp vec2 tmpvar_337;
      tmpvar_337 = (-((
        ((alpha_319 * tmpvar_332) / (tmpvar_321 + 0.0001))
       * deltaFactorY_316)) * (dir_320 - tmpvar_335));
      positionToUse_318.x = ((positionToUse_4.x + tmpvar_336.x) + tmpvar_337.x);
      positionToUse_318.y = (positionToUse_4.y + ((
        (tmpvar_336.y + tmpvar_337.y)
       / UNIFORM_RATIOASPECT) * 1.765));
      tmpvar_317 = positionToUse_318;
    };
    displacement_2 = ((displacement_2 + tmpvar_317) - positionToUse_4);
  };
  if ((UNIFORM_OUTERCANTHUS_COEF > 0.001)) {
    for (highp int j_7_338 = 0; j_7_338 < 6; j_7_338++) {
      highp vec2 src_339;
      src_339 = UNIFORM_OUTERCANTHUS_PTS[j_7_338].xy;
      highp vec2 dst_340;
      dst_340 = UNIFORM_OUTERCANTHUS_PTS[j_7_338].zw;
      highp float radiusFactor_341;
      radiusFactor_341 = OUTERCANTHUS_PARAMRADIUS[j_7_338].x;
      highp float deltaFactorX_342;
      deltaFactorX_342 = (-(OUTERCANTHUS_PARAM[j_7_338].x) * outercanthusCoef_7);
      highp float deltaFactorY_343;
      deltaFactorY_343 = ((-(OUTERCANTHUS_PARAM[j_7_338].y) * outercanthusCoef_7) * 5.0);
      highp vec2 tmpvar_344;
      highp vec2 positionToUse_345;
      highp float alpha_346;
      highp vec2 dir_347;
      highp float tmpvar_348;
      tmpvar_348 = sqrt(((deltaFactorX_342 * deltaFactorX_342) + (
        (deltaFactorY_343 * deltaFactorY_343)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_349;
      tmpvar_349.x = positionToUse_4.x;
      tmpvar_349.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_350;
      tmpvar_350.x = src_339.x;
      tmpvar_350.y = (src_339.y * aspectRatio_14);
      highp vec2 tmpvar_351;
      tmpvar_351.x = dst_340.x;
      tmpvar_351.y = (dst_340.y * aspectRatio_14);
      highp vec2 tmpvar_352;
      tmpvar_352 = (tmpvar_349 - tmpvar_350);
      highp float tmpvar_353;
      tmpvar_353 = dot (tmpvar_352, tmpvar_352);
      highp vec2 tmpvar_354;
      tmpvar_354 = (tmpvar_351 - tmpvar_350);
      dir_347.x = tmpvar_354.x;
      dir_347.y = (tmpvar_354.y / 1.765);
      highp float tmpvar_355;
      tmpvar_355 = dot (dir_347, dir_347);
      highp float tmpvar_356;
      tmpvar_356 = ((radiusFactor_341 * radiusFactor_341) * tmpvar_355);
      if ((tmpvar_353 > tmpvar_356)) {
        tmpvar_344 = positionToUse_4;
      } else {
        highp float tmpvar_357;
        tmpvar_357 = sqrt(tmpvar_355);
        dir_347 = (dir_347 / tmpvar_357);
        highp float tmpvar_358;
        tmpvar_358 = (tmpvar_356 - tmpvar_353);
        highp float tmpvar_359;
        tmpvar_359 = (tmpvar_348 * tmpvar_357);
        highp float tmpvar_360;
        tmpvar_360 = (sqrt(tmpvar_353) - tmpvar_359);
        highp float tmpvar_361;
        tmpvar_361 = (tmpvar_358 / (tmpvar_358 + (tmpvar_360 * tmpvar_360)));
        alpha_346 = (tmpvar_361 * tmpvar_361);
        highp vec2 tmpvar_362;
        tmpvar_362 = (dot (dir_347, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_363;
        tmpvar_363 = (-((
          ((alpha_346 * tmpvar_359) / (tmpvar_348 + 0.0001))
         * deltaFactorX_342)) * tmpvar_362);
        highp vec2 tmpvar_364;
        tmpvar_364 = (-((
          ((alpha_346 * tmpvar_359) / (tmpvar_348 + 0.0001))
         * deltaFactorY_343)) * (dir_347 - tmpvar_362));
        positionToUse_345.x = ((positionToUse_4.x + tmpvar_363.x) + tmpvar_364.x);
        positionToUse_345.y = (positionToUse_4.y + ((
          (tmpvar_363.y + tmpvar_364.y)
         / aspectRatio_14) * 1.765));
        tmpvar_344 = positionToUse_345;
      };
      displacement_2 = ((displacement_2 + tmpvar_344) - positionToUse_4);
    };
  };
  if ((UNIFORM_PHILTRUMCOEF > 0.001)) {
    for (highp int j_8_365 = 0; j_8_365 < 4; j_8_365++) {
      highp vec2 src_366;
      src_366 = PHILTRUMPOINTS[j_8_365].xy;
      highp vec2 dst_367;
      dst_367 = PHILTRUMPOINTS[j_8_365].zw;
      highp float radiusFactor_368;
      radiusFactor_368 = PHILTRUMPARAMS[j_8_365].y;
      highp float deltaFactorY_369;
      deltaFactorY_369 = (PHILTRUMPARAMS[j_8_365].x * philtrumCoef_9);
      highp vec2 tmpvar_370;
      highp vec2 positionToUse_371;
      highp vec2 dir_372;
      highp float tmpvar_373;
      tmpvar_373 = sqrt(((deltaFactorY_369 * deltaFactorY_369) * (aspectRatio_14 * aspectRatio_14)));
      highp vec2 tmpvar_374;
      tmpvar_374.x = positionToUse_4.x;
      tmpvar_374.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_375;
      tmpvar_375.x = src_366.x;
      tmpvar_375.y = (src_366.y * aspectRatio_14);
      highp vec2 tmpvar_376;
      tmpvar_376.x = dst_367.x;
      tmpvar_376.y = (dst_367.y * aspectRatio_14);
      highp vec2 tmpvar_377;
      tmpvar_377 = (tmpvar_374 - tmpvar_375);
      highp float tmpvar_378;
      tmpvar_378 = dot (tmpvar_377, tmpvar_377);
      highp vec2 tmpvar_379;
      tmpvar_379 = (tmpvar_376 - tmpvar_375);
      dir_372.x = tmpvar_379.x;
      dir_372.y = (tmpvar_379.y / 1.765);
      highp float tmpvar_380;
      tmpvar_380 = dot (dir_372, dir_372);
      highp float tmpvar_381;
      tmpvar_381 = ((radiusFactor_368 * radiusFactor_368) * tmpvar_380);
      if ((tmpvar_378 > tmpvar_381)) {
        tmpvar_370 = positionToUse_4;
      } else {
        highp float tmpvar_382;
        tmpvar_382 = sqrt(tmpvar_380);
        dir_372 = (dir_372 / tmpvar_382);
        highp float tmpvar_383;
        tmpvar_383 = (tmpvar_381 - tmpvar_378);
        highp float tmpvar_384;
        tmpvar_384 = (tmpvar_373 * tmpvar_382);
        highp float tmpvar_385;
        tmpvar_385 = (sqrt(tmpvar_378) - tmpvar_384);
        highp float tmpvar_386;
        tmpvar_386 = (tmpvar_383 / (tmpvar_383 + (tmpvar_385 * tmpvar_385)));
        highp vec2 tmpvar_387;
        tmpvar_387 = (-((
          (((tmpvar_386 * tmpvar_386) * tmpvar_384) / (tmpvar_373 + 0.0001))
         * deltaFactorY_369)) * (dir_372 - (
          dot (dir_372, face_dir_3)
         * face_dir_3)));
        positionToUse_371.x = (positionToUse_4.x + tmpvar_387.x);
        positionToUse_371.y = (positionToUse_4.y + ((tmpvar_387.y / aspectRatio_14) * 1.765));
        tmpvar_370 = positionToUse_371;
      };
      displacement_2 = ((displacement_2 + tmpvar_370) - positionToUse_4);
    };
  };
  if ((UNIFORM_EYEBROWCOEF > 0.001)) {
    for (highp int j_9_388 = 0; j_9_388 < 4; j_9_388++) {
      highp vec2 src_389;
      src_389 = EYEBROWPOINTS[j_9_388].xy;
      highp vec2 dst_390;
      dst_390 = EYEBROWPOINTS[j_9_388].zw;
      highp float radiusFactor_391;
      radiusFactor_391 = EYEBROWPARARADIUS[j_9_388].x;
      highp float deltaFactorX_392;
      deltaFactorX_392 = (EYEBROWPARA[j_9_388].x * eyebrowCoef_6);
      highp float deltaFactorY_393;
      deltaFactorY_393 = (EYEBROWPARA[j_9_388].y * eyebrowCoef_6);
      highp vec2 tmpvar_394;
      highp vec2 positionToUse_395;
      highp float alpha_396;
      highp vec2 dir_397;
      highp float tmpvar_398;
      tmpvar_398 = sqrt(((deltaFactorX_392 * deltaFactorX_392) + (
        (deltaFactorY_393 * deltaFactorY_393)
       * 
        (aspectRatio_14 * aspectRatio_14)
      )));
      highp vec2 tmpvar_399;
      tmpvar_399.x = positionToUse_4.x;
      tmpvar_399.y = (positionToUse_4.y * aspectRatio_14);
      highp vec2 tmpvar_400;
      tmpvar_400.x = src_389.x;
      tmpvar_400.y = (src_389.y * aspectRatio_14);
      highp vec2 tmpvar_401;
      tmpvar_401.x = dst_390.x;
      tmpvar_401.y = (dst_390.y * aspectRatio_14);
      highp vec2 tmpvar_402;
      tmpvar_402 = (tmpvar_399 - tmpvar_400);
      highp float tmpvar_403;
      tmpvar_403 = dot (tmpvar_402, tmpvar_402);
      highp vec2 tmpvar_404;
      tmpvar_404 = (tmpvar_401 - tmpvar_400);
      dir_397.x = tmpvar_404.x;
      dir_397.y = (tmpvar_404.y / 1.765);
      highp float tmpvar_405;
      tmpvar_405 = dot (dir_397, dir_397);
      highp float tmpvar_406;
      tmpvar_406 = ((radiusFactor_391 * radiusFactor_391) * tmpvar_405);
      if ((tmpvar_403 > tmpvar_406)) {
        tmpvar_394 = positionToUse_4;
      } else {
        highp float tmpvar_407;
        tmpvar_407 = sqrt(tmpvar_405);
        dir_397 = (dir_397 / tmpvar_407);
        highp float tmpvar_408;
        tmpvar_408 = (tmpvar_406 - tmpvar_403);
        highp float tmpvar_409;
        tmpvar_409 = (tmpvar_398 * tmpvar_407);
        highp float tmpvar_410;
        tmpvar_410 = (sqrt(tmpvar_403) - tmpvar_409);
        highp float tmpvar_411;
        tmpvar_411 = (tmpvar_408 / (tmpvar_408 + (tmpvar_410 * tmpvar_410)));
        alpha_396 = (tmpvar_411 * tmpvar_411);
        highp vec2 tmpvar_412;
        tmpvar_412 = (dot (dir_397, face_dir_3) * face_dir_3);
        highp vec2 tmpvar_413;
        tmpvar_413 = (-((
          ((alpha_396 * tmpvar_409) / (tmpvar_398 + 0.0001))
         * deltaFactorX_392)) * tmpvar_412);
        highp vec2 tmpvar_414;
        tmpvar_414 = (-((
          ((alpha_396 * tmpvar_409) / (tmpvar_398 + 0.0001))
         * deltaFactorY_393)) * (dir_397 - tmpvar_412));
        positionToUse_395.x = ((positionToUse_4.x + tmpvar_413.x) + tmpvar_414.x);
        positionToUse_395.y = (positionToUse_4.y + ((
          (tmpvar_413.y + tmpvar_414.y)
         / aspectRatio_14) * 1.765));
        tmpvar_394 = positionToUse_395;
      };
      displacement_2 = ((displacement_2 + tmpvar_394) - positionToUse_4);
    };
  };
  highp float tmpvar_415;
  tmpvar_415 = abs(UNIFORM_MOUTHCOEF);
  if ((tmpvar_415 > 0.001)) {
    highp vec2 tmpvar_416;
    tmpvar_416 = (MOUTHPOINTS[3] - MOUTHPOINTS[2]);
    highp vec2 tmpvar_417;
    tmpvar_417 = ((MOUTHPOINTS[0] - MOUTHPOINTS[1]) + ((MOUTHTRIANGLEPOINTTARGET[10] - MOUTHTRIANGLEPOINTSOUECE[10]) * 2.0));
    highp float tmpvar_418;
    tmpvar_418 = sqrt(((
      sqrt(dot (tmpvar_416, tmpvar_416))
     / 
      sqrt(dot (tmpvar_417, tmpvar_417))
    ) * MOUTHPARAMS[1].y));
    highp float tmpvar_419;
    tmpvar_419 = (sqrt(dot (tmpvar_416, tmpvar_416)) * MOUTHPARAMS[0].x);
    highp float tmpvar_420;
    tmpvar_420 = (sqrt(dot (tmpvar_416, tmpvar_416)) * MOUTHPARAMS[0].y);
    highp vec2 tmpvar_421;
    tmpvar_421 = (((
      (MOUTHPOINTS[0] + MOUTHPOINTS[1])
     + MOUTHPOINTS[2]) + MOUTHPOINTS[3]) / 4.0);
    highp vec2 m_point_422;
    highp vec2 tmpvar_423;
    tmpvar_423.x = -(face_dir_3.y);
    tmpvar_423.y = face_dir_3.x;
    m_point_422 = positionToUse_4;
    highp vec2 tmpvar_424;
    tmpvar_424.x = positionToUse_4.x;
    highp float tmpvar_425;
    tmpvar_425 = (0.5 * UNIFORM_RATIOASPECT);
    tmpvar_424.y = (((positionToUse_4.y * UNIFORM_RATIOASPECT) + 0.5) - (tmpvar_425 * tmpvar_418));
    highp vec2 tmpvar_426;
    tmpvar_426.x = tmpvar_421.x;
    tmpvar_426.y = (((tmpvar_421.y * UNIFORM_RATIOASPECT) + 0.5) - (tmpvar_425 * tmpvar_418));
    highp vec2 tmpvar_427;
    tmpvar_427 = (tmpvar_424 - tmpvar_426);
    highp float tmpvar_428;
    tmpvar_428 = dot (tmpvar_427, face_dir_3);
    highp float tmpvar_429;
    tmpvar_429 = dot (tmpvar_427, tmpvar_423);
    highp float tmpvar_430;
    tmpvar_430 = sqrt(((tmpvar_428 * tmpvar_428) + (
      (tmpvar_429 * tmpvar_429)
     * 
      (tmpvar_418 * tmpvar_418)
    )));
    highp float tmpvar_431;
    tmpvar_431 = (((tmpvar_419 - tmpvar_420) / tmpvar_420) * (MOUTHPARAMS[1].x * UNIFORM_MOUTHCOEF));
    highp float tmpvar_432;
    tmpvar_432 = (tmpvar_420 * (1.0 + tmpvar_431));
    if ((tmpvar_430 < tmpvar_432)) {
      m_point_422 = (tmpvar_421 + ((positionToUse_4 - tmpvar_421) * (1.0/(
        (1.0 + tmpvar_431)
      ))));
    } else {
      if ((tmpvar_430 < tmpvar_419)) {
        m_point_422 = (tmpvar_421 + ((
          (positionToUse_4 - tmpvar_421)
         * 
          (tmpvar_419 - (((tmpvar_419 - tmpvar_430) / (tmpvar_419 - tmpvar_432)) * (tmpvar_419 - tmpvar_420)))
        ) / tmpvar_430));
      };
    };
    displacement_2 = ((displacement_2 + m_point_422) - positionToUse_4);
  };
  positionToUse_4 = (positionToUse_4 + displacement_2);
  highp vec2 tmpvar_433;
  tmpvar_433 = ((0.5 * positionToUse_4) + 0.5);
  highp vec4 tmpvar_434;
  tmpvar_434.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_434.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_435;
  tmpvar_435.x = tmpvar_433.x;
  tmpvar_435.y = (1.0 - tmpvar_433.y);
  xlv_TEXCOORD0 = tmpvar_435;
  gl_Position = (tmpvar_434 * tmpvar_18);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 outColor_1;
  highp vec2 tmpvar_2;
  tmpvar_2 = clamp (xlv_TEXCOORD0, vec2(0.001, 0.001), vec2(0.999, 0.999));
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, tmpvar_2);
  outColor_1 = tmpvar_3;
  _glesFragData[0] = outColor_1;
}

]===],
	},
}

end
