
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_CROPCENTER = { "Crop Center", VEC2, "0.0,0.0"},
UNIFORM_CROPSCALE = { "Crop Scale", VEC2, "1.0,1.0"},
UNIFORM_EDGEJUDGE = { "Edge Judge", FLOAT, "1.0"},
UNIFORM_EDGEALPHA3 = { "Edge Alpha", VEC3, "1.0,1.0,1.0"},
#END

#DEFTAG
ShaderName = "FaceCrop"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF,DEPTH_FUNCTION_LESS  }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 radius : TEXCOORD1;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float radius : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 UNIFORM_CROPCENTER;
float2 UNIFORM_CROPSCALE;
float UNIFORM_EDGEJUDGE;
float3 UNIFORM_EDGEALPHA;

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = (v.vertex);
    float2 flipVertex = float2(v.vertex.x, -v.vertex.y);
	o.uv = (float2(1.0,1.0) + flipVertex)/2.0;
    float2 pos = UNIFORM_CROPCENTER+(in_Position.xy-UNIFORM_CROPCENTER)*UNIFORM_CROPSCALE;
    o.radius = v.radius;
	o.vertex = UniformNDC(float4(pos,0.0,1.0));
	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 bgColor = tex2D(TEXTURE_DIFFUSE, i.uv);
    float disedge = UNIFORM_EDGEJUDGE;
	float4 resColor;
    if(i.radius < disedge)
    {
       resColor = bgColor;
	}
    else
    {
       float alpha = 1.0-(i.radius-disedge)/(1.0-disedge);
       float k = UNIFORM_EDGEALPHA.x;
       float p0y = UNIFORM_EDGEALPHA.y;
       float p2y = UNIFORM_EDGEALPHA.z;
       float alphabe = (1.0-alpha)*(1.0-alpha)*p0y+2.0*alpha*(1.0-alpha)*k+alpha*alpha*p2y;
       resColor = float4(bgColor.rgb,alphabe);
    }
	return resColor;
}
ENDCG
#END
