
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_CROPCENTER = { "Crop Center", VEC2, "0.0,0.0"},
UNIFORM_CROPSCALE = { "Crop Scale", VEC2, "1.0,1.0"},
UNIFORM_EDGEJUDGE = { "Edge Judge", FLOAT, "1.0"},
UNIFORM_EDGEALPHA3 = { "Edge Alpha", VEC3, "1.0,1.0,1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "FaceCrop"
RenderQueue = "Opaque"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF,DEPTH_FUNCTION_LESS  }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_CROPCENTER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_CROPSCALE",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EDGEJUDGE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EDGEALPHA",
				varType = "float3",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord1;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 UNIFORM_CROPCENTER;
uniform highp vec2 UNIFORM_CROPSCALE;
out highp vec2 xlv_TEXCOORD0;
out highp float xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1.x = _glesVertex.x;
  tmpvar_1.y = -(_glesVertex.y);
  highp vec4 tmpvar_2;
  tmpvar_2.zw = vec2(0.0, 1.0);
  tmpvar_2.xy = (UNIFORM_CROPCENTER + ((_glesVertex.xy - UNIFORM_CROPCENTER) * UNIFORM_CROPSCALE));
  highp vec4 tmpvar_3;
  tmpvar_3.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_3.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = ((vec2(1.0, 1.0) + tmpvar_1) / 2.0);
  xlv_TEXCOORD1 = _glesMultiTexCoord1.x;
  gl_Position = (tmpvar_3 * tmpvar_2);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float UNIFORM_EDGEJUDGE;
uniform highp vec3 UNIFORM_EDGEALPHA;
in highp vec2 xlv_TEXCOORD0;
in highp float xlv_TEXCOORD1;
void main ()
{
  highp vec4 resColor_1;
  highp vec4 bgColor_2;
  lowp vec4 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0);
  bgColor_2 = tmpvar_3;
  if ((xlv_TEXCOORD1 < UNIFORM_EDGEJUDGE)) {
    resColor_1 = bgColor_2;
  } else {
    highp float tmpvar_4;
    tmpvar_4 = (1.0 - ((xlv_TEXCOORD1 - UNIFORM_EDGEJUDGE) / (1.0 - UNIFORM_EDGEJUDGE)));
    highp vec4 tmpvar_5;
    tmpvar_5.xyz = bgColor_2.xyz;
    tmpvar_5.w = (((
      ((1.0 - tmpvar_4) * (1.0 - tmpvar_4))
     * UNIFORM_EDGEALPHA.y) + (
      ((2.0 * tmpvar_4) * (1.0 - tmpvar_4))
     * UNIFORM_EDGEALPHA.x)) + ((tmpvar_4 * tmpvar_4) * UNIFORM_EDGEALPHA.z));
    resColor_1 = tmpvar_5;
  };
  _glesFragData[0] = resColor_1;
}

]===],
	},
}

end
