local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"
local am = require "mathfunction"
local rendernode = require "apolloutility.apollonode.rendernode"
local facetrigger = require "game.facetrigger"
local paradef = nil;
--facecrop类型
local facecrop = facetrigger:extend();
function facecrop:new(maincamera)
  self.maincamera = maincamera;
  facecrop.super.new(self);  
  self.typeId = 0;
  self.bParse = false;
  facecrop.super.SetShow(self, false);
  --self.ptcount = paradef.interPtCount;
  
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  
    apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1 =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.ATTRIBUTE,
      "ATTRIBUTE_COORDNATE1");
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    1);
  
  --[[self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);]]


  
end


function facecrop:InitVertexAndIndex()
  
  
  self.mouthpara={};
  local para = self.mouthpara;
  self.ptcount = paradef.interPtCount;
  self.indicesstream = apolloengine.IndicesStream();--创建索引流 
  self.indicesstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  local facecorpmouthptcount = self:GetFaceCropPtCount();
  

  self.vertexstream:ReserveBuffer((facecorpmouthptcount*self.ptcount/2)+1);
  local facecorpmouthindexcount = self:GetFaceCropTriIndexCount();
  self.indicesstream:ReserveBuffer(facecorpmouthptcount*self.ptcount/2*3);

  self:InitVertexSteam();
  self:InitIndexStream();

end


function facecrop:InitVertexSteam()
  local facecorpmouthptcount = self:GetFaceCropPtCount();
  
  --bound
  for i =1,facecorpmouthptcount do
          self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1));
    
             self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
      mathfunction.vector1(1));
  end
  
  --center
  self.vertexstream:PushVertexData(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    mathfunction.vector4(0,0,0,1)
  );
  
    
  self.vertexstream:PushVertexData(
  apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
  mathfunction.vector1(0));
  
end

function facecrop:InitIndexStream()
  local triIndex = self:GetFaceCropTriIndex();
  local startIndex = paradef.mouthStartIndex;
  if(triIndex ) 
   then
     local indiceAdd = triIndex;
     local len = #indiceAdd;
      for j=1,len/3 do
            
            self.indicesstream:PushIndicesData(indiceAdd[3*j-2]-startIndex);
            self.indicesstream:PushIndicesData(indiceAdd[3*j-1]-startIndex);
            self.indicesstream:PushIndicesData(indiceAdd[3*j]-startIndex);
      end
    end
end
  
function facecrop:GetFaceCropTriIndex()
  return nil;
end
function facecrop:GetFaceCropPtCount()
  return 1;
end

function facecrop:GetFaceCropTriIndexCount()
  return 1;
end

function facecrop:GetIndexStream(config)
  return self.indicesstream;
end

function facecrop:GetVertexStream(config)
  return self.vertexstream;
end

function facecrop:GetMaterailPath(config)
  return nil;
end

function facecrop:GetRenderMode()
    return apolloengine.RenderComponent.RM_TRIANGLES;
end

function facecrop:CreateRenderResource(config)


   -- self.render:CreateResource(
   -- materialpath,
   -- apolloengine.RenderComponent.RM_TRIANGLES,
   -- self.vertexstream,
   -- self.indicesstream);
    local indexStream  = self:GetIndexStream(config);
    local vertexStream = self:GetVertexStream(config);
    local materialpath = self:GetMaterailPath(config);
    local rendermode   = self:GetRenderMode(config);
   
  
   local res = self:CreateResource(
    materialpath,
    rendermode,
    vertexStream,
    indexStream);
  
end
--

function facecrop:_ChangeVertex()
  local OriginalFaceCoords  =  self:GetFaceCoods();  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    1,
    2,
    OriginalFaceCoords);  
  
end


function facecrop:_ChangeVertexBuffer()
  self.render:ChangeVertexBuffer(self.vertexstream);
end

function facecrop:UpdateVertex()
  self:_ChangeVertex();
  self:_ChangeVertexBuffer();
end

function facecrop:Initialize(config)
  
 paradef = self.mouthpara;
 self:InitVertexAndIndex();
 self:CreateRenderResource(config);
end

return facecrop;






