
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_CENTER = { "Center", VEC2, "0.0,0.0"},
UNIFORM_SCALE = { "Scale", FLOAT, "1.0"},
UNIFORM_AMP = { "Amp", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "Dolly"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_CENTER",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_SCALE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_AMP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec2 UNIFORM_CENTER;
uniform highp float UNIFORM_SCALE;
out highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  xlv_TEXCOORD0 = (((
    ((((_glesMultiTexCoord0.xy * vec2(2.0, 2.0)) - vec2(1.0, 1.0)) - UNIFORM_CENTER) / (1.0 + UNIFORM_SCALE))
   + UNIFORM_CENTER) * vec2(0.5, 0.5)) + vec2(0.5, 0.5));
  gl_Position = (tmpvar_1 * _glesVertex);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform highp float UNIFORM_AMP;
in highp vec2 xlv_TEXCOORD0;
void main ()
{
  highp vec3 greyrgb_1;
  highp vec3 rgb_2;
  lowp vec3 tmpvar_3;
  tmpvar_3 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD0).xyz;
  rgb_2 = tmpvar_3;
  greyrgb_1 = (((vec3(
    dot (rgb_2, vec3(0.3, 0.59, 0.11))
  ) - vec3(0.5, 0.5, 0.5)) * 1.5) + vec3(0.5, 0.5, 0.5));
  highp vec3 tmpvar_4;
  if ((UNIFORM_AMP > 0.5)) {
    tmpvar_4 = greyrgb_1;
  } else {
    tmpvar_4 = rgb_2;
  };
  rgb_2 = tmpvar_4;
  highp vec4 tmpvar_5;
  tmpvar_5.w = 1.0;
  tmpvar_5.xyz = tmpvar_4;
  _glesFragData[0] = tmpvar_5;
}

]===],
	},
}

end
