
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_RED = { "Tex Red", TEXTURE2D, "white" },
TEXTURE_GREEN = { "Tex Green", TEXTURE2D, "white" },
TEXTURE_BLUE = { "Tex Blue", TEXTURE2D, "white" },
UNIFORM_RGBSCALE = { "Rgb scale", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "Historicalrgb"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_RED;
sampler2D TEXTURE_GREEN;
sampler2D TEXTURE_BLUE;
float UNIFORM_RGBSCALE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

float4 frag(v2f i) : SV_Target
{
    float timescale = 0.5;
    float2 textureCoordinate = i.uv;
    float4 rgb =  tex2D(TEXTURE_DIFFUSE, textureCoordinate);
    float4 rgb1 = tex2D(TEXTURE_RED, textureCoordinate);
    float4 rgb2 = tex2D(TEXTURE_GREEN, textureCoordinate);
    float4 rgb3 = tex2D(TEXTURE_BLUE, textureCoordinate);
    float3 newrgb = float3(rgb1.r,rgb2.g,rgb3.b);
    newrgb = float3(clamp(newrgb.r,0.0,1.0),clamp(newrgb.g,0.0,1.0),clamp(newrgb.b,0.0,1.0));

    return float4(newrgb, 1.0);
}
ENDCG
#END
