local apolloengine = require "apolloengine"
local venuscore = require "venuscore"

local historicalrgb = {}
historicalrgb.hisrgb = 0;
historicalrgb.Queue = 320;

function historicalrgb:Initialize(host, size)
  self.TEXTURE_TESTR = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"TEXTURE_RED");
  self.TEXTURE_TESTG = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"TEXTURE_GREEN");
  self.TEXTURE_TESTB = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"TEXTURE_BLUE");
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"TEXTURE_MASK");
  self.UNIFORM_RGBSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RGBSCALE");
  local pathout = venuscore.IFileSystem:PathAssembly("docs:filter/historicalrgb/filter/resource/material/historicalrgb.material");  
  self.hisrgb = host:CreateRenderObject(pathout);
  return self.Queue;
end

function historicalrgb:Resizeview(size)
end

function historicalrgb:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.hisrgb:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.hisrgb:Draw(pipeline);
end

return historicalrgb;