

#DEFPARAMS
UNIFORM_CUSTOMER_DEPTH = { "colorMiddle", FLOAT, "0"},
UNIFORM_POSOFFSET = { "pos offset", VEC2, "0, 0"},
TEXTURE_DIFFUSE_RGB = { "diffuse rgb", TEXTURE2D, "white"},
TEXTURE_DIFFUSE_ALPHA = { "diffuse alpha", TEXTURE2D, "white"},
TEXTURE_DIFFUSE_BGALPHA = { "bg alpha", TEXTURE2D, "white"},
UNIFORM_FADE = { "fade", FLOAT, "1"},
#END

#DEFTAG
ShaderName = "sticker2dmatnormal"
RenderQueue = "Transparent+200"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE_MINUS_SRC_COLOR, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float2 bgpos : TEXCOORD1;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float2 bgpos : TEXCOORD1;
	float4 vertex : SV_POSITION;
};

float4x4 UNIFORM_MATMVP;
float UNIFORM_CUSTOMER_DEPTH;
float2 UNIFORM_POSOFFSET;
sampler2D TEXTURE_DIFFUSE_RGB;
sampler2D TEXTURE_DIFFUSE_ALPHA;
sampler2D TEXTURE_DIFFUSE_BGALPHA;
float UNIFORM_FADE;

v2f vert(appdata v)
{
	v2f o;
	float4x4 umat = float4x4(1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,  0.0,0.0,1.0,0.0,  0.0,0.0,0.0,1.0);
    float4 rotpos = mul(UNIFORM_MATMVP, v.vertex);
    o.vertex = float4(rotpos.xy+UNIFORM_POSOFFSET*rotpos.w, UNIFORM_CUSTOMER_DEPTH*rotpos.w, rotpos.w);
    o.vertex = UniformNDC(o.vertex); 
	o.uv = v.uv;
	o.bgpos = (rotpos.xy/rotpos.w+float2(1.0,1.0))/2.0;
    o.bgpos.y = 1.0 - o.bgpos.y;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 rgb = tex2D(TEXTURE_DIFFUSE_RGB, i.uv).rgb;
    float posAlpha = tex2D(TEXTURE_DIFFUSE_ALPHA, i.uv).a;
    float bgAlpha = 1.0-tex2D(TEXTURE_DIFFUSE_BGALPHA, i.bgpos).r;
    float4 mainColor = float4(rgb*posAlpha*bgAlpha*UNIFORM_FADE, posAlpha*bgAlpha*UNIFORM_FADE);
	return mainColor;
}
ENDCG
#END
