//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////
#include "functions/rgb_hsv.function"
#include "functions/lut.function"
#include "functions/brightadjust.function"
#SHADER_DEFINE HeadBoundingBoxVertex

    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,            HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,       HIGH,    MAT4,        "in_Transfrom" },
        { ATTRIBUTE_POSITION,         HIGH,    VEC4,        "in_Position" },
				{ ATTRIBUTE_COORDNATE0,				MEDIUM,		VEC2,				"in_Coordinate"},

    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     HIGH,    VEC4,        "in_ScreenPosition" },
				{ ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,					"out_Coordinate" },
    }
#SHADER_CODE
    vec4 in_ScreenPosition  = in_ViewPorj * in_Position;
    mediump vec2 out_Coordinate = in_Coordinate;
		gl_Position = in_ScreenPosition;

#END_CODE
#END_DEFINE

#SHADER_DEFINE HeadBoundingBoxFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  lowp vec4 TextureColor = texture2D( in_DiffuseTexture, in_Coordinate );
  gl_FragColor = vec4(TextureColor.r * TextureColor.a,TextureColor.g * TextureColor.a,TextureColor.b * TextureColor.a,1.0);
  //gl_FragColor = TextureColor;

#END_CODE
#END_DEFINE

#SHADER_DEFINE QuadClear

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
  FUNCTION_OUTPUT =
  {
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
  }
#SHADER_CODE
  vec2 out_TexCooridate = in_TexCooridate.xy;
  gl_Position = in_Position;

#END_CODE
#END_DEFINE

#SHADER_DEFINE FragmentZero

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		      NONE,	TEXTURE2D,  "in_SrcTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		    "in_TexCoordinate"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  gl_FragColor = vec4(0.0,0.0,0.0,0.0);
  //gl_FragColor = texture2D(in_SrcTexture,in_TexCoordinate);
#END_CODE
#END_DEFINE



#SHADER_DEFINE ChangeColorVertex

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;

#END_CODE
#END_DEFINE

#SHADER_DEFINE ChangeColorFragment

	FUNCTION_INPUT =
	{
    { TEXTURE_DIFFUSE,		      NONE,	TEXTURE2D,  "in_SrcTexture" },
    { TEXTURE_TO_COLOR,         NONE, TEXTURE2D,  "in_ToColor"},
    { TEXTURE_MASK,             NONE, TEXTURE2D,  "in_ColorMask"},
    { TEXTURE_LUT,		          NONE,	TEXTURE2D,	"in_TextureLUT" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		    "in_TexCoordinate"},
    { BIRGHTNESS,               HIGH, FLOAT,      "in_Brightness"},
    --{ BIRGHTNESS_RANGE,         HIGH, VEC2,       "in_BrightnessRange"},
    --{ BRIGHTNESS_RANGE,        HIGH, VEC3,       "in_BrightnessRange"},
    {BRIGHTNESS_CURVECOEF,          HIGH, VEC4,        "in_BrightnessCurveCoef"},
    {SATURATION_CURVECOEF,          HIGH, VEC4,        "in_SaturationCurveCoef"},
    --{XYMIN,HIGH,VEC2,"xymin"},
    --{XYMAX, HIGH, VEC2,"xymax"},
  }

FUNCTION_OUTPUT =
	{
	}

#SHADER_CODE
    highp vec4 mask = texture2D(in_ColorMask, vec2(in_TexCoordinate.x, 1.0 - in_TexCoordinate.y));
    highp vec4 src_color = texture2D(in_SrcTexture,vec2(in_TexCoordinate.x, 1.0 - in_TexCoordinate.y));
    highp vec3 src_hsv = rgb2hsv(src_color.xyz);
    //对头发原亮度进行亮度映射
    highp float final_src_brightness = 0.0;
    /*if (src_hsv.z < 0.5)
      final_src_brightness = in_BrightnessRange.x + (src_hsv.z / 0.5) * (in_BrightnessRange.y - in_BrightnessRange.x);
    else
      final_src_brightness = in_BrightnessRange.y + ((src_hsv.z - 0.5) / 0.5 )* (in_BrightnessRange.z - in_BrightnessRange.y);*/
    //调亮度曲线
    final_src_brightness = brightadjust(in_BrightnessCurveCoef.x,in_BrightnessCurveCoef.y,in_BrightnessCurveCoef.z,in_BrightnessCurveCoef.w,src_hsv.z);
    highp vec4 in_ToColor = texture2D(in_ToColor,in_TexCoordinate);
    highp vec3 dst_hsv = rgb2hsv(in_ToColor.xyz);
    src_hsv = vec3(dst_hsv.x,dst_hsv.y,final_src_brightness);  //调整亮度
    highp vec3 dst_rgb = clamp(hsv2rgb(src_hsv),vec3(0.0,0.0,0.0),vec3(1.0,1.0,1.0));
    dst_hsv = rgb2hsv(dst_rgb);
    //调饱和度曲线
    float saturaion = brightadjust(in_SaturationCurveCoef.x,in_SaturationCurveCoef.y,in_SaturationCurveCoef.z,in_SaturationCurveCoef.w,dst_hsv.y);
    src_hsv = vec3(dst_hsv.x,saturaion,dst_hsv.z);

    dst_rgb = clamp(hsv2rgb(src_hsv),vec3(0.0,0.0,0.0),vec3(1.0,1.0,1.0));
    highp float maskf = clamp((1.0 - in_ToColor.a) + (1.0 - mask.r),0.0,1.0);
    highp vec3 final_rgb = (src_color.rgb * maskf) + (dst_rgb * (1.0 - maskf));
    gl_FragColor = vec4(final_rgb,src_color.a);

    //以下测试用
    //gl_FragColor = in_ToColor + src_color + mask;
    //画rect范围
    //if(in_TexCoordinate.x >xymin.x*0.5+0.5 && in_TexCoordinate.y >xymin.y*0.5+0.5 && in_TexCoordinate.x< xymax.x*0.5+0.5 && in_TexCoordinate.y <xymax.y*0.5+0.5){
      //gl_FragColor = mask;
    //}
#END_CODE
#END_DEFINE




#SHADER_DEFINE LaplaceVertex
	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
    { TEXTURE_SIZE,         MEDIUM,   VEC2,     "in_TexSize"},

	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
		--{ LAPLACE_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_LaplaceCoord", "9" },
	}

#SHADER_CODE
  vec2 out_TexCooridate = in_Coordinate.xy;
  gl_Position = in_Position;
#END_CODE
#END_DEFINE



#SHADER_DEFINE LaplaceFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"in_DiffuseTexture" },
		--{ LAPLACE_COORDNATE,		MEDIUM,	VEC2_ARRAY,		"in_LaplaceCoord", "9" },
    { TEXTURE_MASK,             NONE, TEXTURE2D,  "in_ColorMask"},
    { TEXTURE_SIZE,         MEDIUM,   VEC2,     "in_TexSize"},
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		    "in_Coordinate"},
    { SHARPEN_STRENGTH,         HIGH,  FLOAT,      "in_SharpenStregth"},
	}
	FUNCTION_OUTPUT =
	{
	}

#SHADER_CODE
  highp vec2 offset0=vec2(-1.0,-1.0); highp vec2 offset1=vec2(0.0,-1.0); highp vec2 offset2=vec2(1.0,-1.0);
	highp vec2 offset3=vec2(-1.0,0.0); highp vec2 offset4=vec2(0.0,0.0); highp vec2 offset5=vec2(1.0,0.0);
	highp vec2 offset6=vec2(-1.0,1.0); highp vec2 offset7=vec2(0.0,1.0); highp vec2 offset8=vec2(1.0,1.0);
  highp vec2 in_LaplaceCoord[9];
  in_LaplaceCoord[0] = in_Coordinate.st + offset0.xy/in_TexSize;
	in_LaplaceCoord[1] = in_Coordinate.st + offset1.xy/in_TexSize;
	in_LaplaceCoord[2] = in_Coordinate.st + offset2.xy/in_TexSize;
	in_LaplaceCoord[3] = in_Coordinate.st + offset3.xy/in_TexSize;
	in_LaplaceCoord[4] = in_Coordinate.st + offset4.xy/in_TexSize;
	in_LaplaceCoord[5] = in_Coordinate.st + offset5.xy/in_TexSize;
	in_LaplaceCoord[6] = in_Coordinate.st + offset6.xy/in_TexSize;
	in_LaplaceCoord[7] = in_Coordinate.st + offset7.xy/in_TexSize;
	in_LaplaceCoord[8] = in_Coordinate.st + offset8.xy/in_TexSize;

	highp float scaleFactor = in_SharpenStregth;//给出最终求和时的加权因子(为调整亮度)
	highp float kernelValue0 = 0.0; highp float kernelValue1 = -1.0; highp float kernelValue2 = 0.0;
	highp float kernelValue3 = -1.0; highp float kernelValue4 = 5.0; highp float kernelValue5 = -1.0;
	highp float kernelValue6 = 0.0; highp float kernelValue7 = -1.0; highp float kernelValue8 = 0.0;
	highp vec4 sum;
	highp vec4 cTemp0,cTemp1,cTemp2,cTemp3,cTemp4,cTemp5,cTemp6,cTemp7,cTemp8;
	cTemp0=texture2D(in_DiffuseTexture, in_LaplaceCoord[0]);
	cTemp1=texture2D(in_DiffuseTexture, in_LaplaceCoord[1]);
	cTemp2=texture2D(in_DiffuseTexture, in_LaplaceCoord[2]);
	cTemp3=texture2D(in_DiffuseTexture, in_LaplaceCoord[3]);
	cTemp4=texture2D(in_DiffuseTexture, in_LaplaceCoord[4]);
	cTemp5=texture2D(in_DiffuseTexture, in_LaplaceCoord[5]);
	cTemp6=texture2D(in_DiffuseTexture, in_LaplaceCoord[6]);
	cTemp7=texture2D(in_DiffuseTexture, in_LaplaceCoord[7]);
	cTemp8=texture2D(in_DiffuseTexture, in_LaplaceCoord[8]);
  highp vec4 mask = texture2D(in_ColorMask, vec2(in_LaplaceCoord[0].x,1.0 - in_LaplaceCoord[0].y));

	sum =kernelValue0*cTemp0+kernelValue1*cTemp1+kernelValue2*cTemp2+
		 kernelValue3*cTemp3+kernelValue4*cTemp4+kernelValue5*cTemp5+
	     kernelValue6*cTemp6+kernelValue7*cTemp7+kernelValue8*cTemp8;
  //vec4 outColor = (sum * scaleFactor + cTemp4 * (1.0 - scaleFactor)) * mask.r + cTemp4 * (1.0 - mask.r);
  vec4 outColor = (sum * scaleFactor + cTemp4 * (1.0 - scaleFactor));
  gl_FragColor = vec4(outColor.rgb,mask.r);
#END_CODE
#END_DEFINE
