
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},
#END


#DEFTAG
ShaderName = "facechangesoftlight"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float2 uvstd : TEXCOORD2;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 texCoord : TEXCOORD0;
	float2 texCoordBag : TEXCOORD1;
	float2 texCoordStd : TEXCOORD2;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BACKG;
float4 UNIFORM_FACETEXPARA;
float UNIFORM_ALPHACOF;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.texCoord = v.uv;
	float2 flipVertex = float2(v.vertex.x, -v.vertex.y);
	o.texCoordBag = (float2(1.0, 1.0) + flipVertex) / 2.0;
	o.texCoordStd = v.uvstd * float2(UNIFORM_FACETEXPARA.x, UNIFORM_FACETEXPARA.y)
								+ float2(UNIFORM_FACETEXPARA.z, UNIFORM_FACETEXPARA.w);
	return o;
}

float4 frag(v2f i) : SV_Target
{
  float4 baseColor = tex2D(TEXTURE_DIFFUSE, i.texCoordBag);
	float4 blendColor = tex2D(TEXTURE_BACKG, i.texCoordStd);
	float r,g,b;
  //blendColor = vec4(0.5);
  if(blendColor.r<0.5)
  {
    r = 2.0*blendColor.r*baseColor.r + baseColor.r*baseColor.r*(1.0-2.0*blendColor.r);
  }
  else
  {
    r =  2.0*baseColor.r*(1.0-blendColor.r) + sqrt(baseColor.r)*(2.0*blendColor.r-1.0); 
  }
  
  if(blendColor.g<0.5)
  {
    g = 2.0*blendColor.g*baseColor.g + baseColor.g*baseColor.g*(1.0-2.0*blendColor.g);
  }
  else
  {
    g =  2.0*baseColor.g*(1.0-blendColor.g) + sqrt(baseColor.g)*(2.0*blendColor.g-1.0);
  }
  
  if(blendColor.b<0.5)
  {
    b = 2.0*blendColor.b*baseColor.b + baseColor.b*baseColor.b*(1.0-2.0*blendColor.b);
  }
  else
  {
    b =  2.0*baseColor.b*(1.0-blendColor.b) + sqrt(baseColor.b)*(2.0*blendColor.b-1.0);
  }
  blendColor.a = step(max(i.texCoordStd.x, i.texCoordStd.y),0.95)*blendColor.a
                      * step(0.05,min(i.texCoordStd.x, i.texCoordStd.y));
  float4 col = float4(float3(clamp(r,0.0,1.0),clamp(g,0.0,1.0),clamp(b,0.0,1.0)),
          blendColor.a*UNIFORM_ALPHACOF);
  return col;
}
ENDCG
#END
