
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "facechangelinedodge"
RenderQueue = "Opaque"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_FACETEXPARA",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_BACKG",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_ALPHACOF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 UNIFORM_FACETEXPARA;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2.x = _glesVertex.x;
  tmpvar_2.y = -(_glesVertex.y);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = ((vec2(1.0, 1.0) + tmpvar_2) / 2.0);
  xlv_TEXCOORD2 = ((_glesMultiTexCoord2.xy * UNIFORM_FACETEXPARA.xy) + UNIFORM_FACETEXPARA.zw);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_BACKG;
uniform highp float UNIFORM_ALPHACOF;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 blendColor_1;
  lowp vec4 tmpvar_2;
  tmpvar_2 = texture (TEXTURE_BACKG, xlv_TEXCOORD2);
  blendColor_1 = tmpvar_2;
  highp vec4 tmpvar_3;
  tmpvar_3.xyz = ((blendColor_1.xyz * blendColor_1.w) * UNIFORM_ALPHACOF);
  tmpvar_3.w = (blendColor_1.w * UNIFORM_ALPHACOF);
  _glesFragData[0] = tmpvar_3;
}

]===],
	},
}

end
