
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background RGB Tex", TEXTURE2D, "white" },
TEXTURE_BACKG_ALPHA = { "Background Alpha Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "facechangeeyeshadow_split"
RenderQueue = "Opaque"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE =  { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_FACETEXPARA",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BACKG_RGB",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BACKG_ALPHA",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 UNIFORM_FACETEXPARA;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2.x = _glesVertex.x;
  tmpvar_2.y = -(_glesVertex.y);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = ((vec2(1.0, 1.0) + tmpvar_2) / 2.0);
  xlv_TEXCOORD2 = ((_glesMultiTexCoord2.xy * UNIFORM_FACETEXPARA.xy) + UNIFORM_FACETEXPARA.zw);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_BACKG_RGB;
uniform sampler2D TEXTURE_BACKG_ALPHA;
in highp vec2 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp float b_1;
  highp float g_2;
  highp float r_3;
  highp float blendColorAlpha_4;
  highp vec3 blendColorRGB_5;
  highp vec4 baseColor_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD1);
  baseColor_6 = tmpvar_7;
  lowp vec3 tmpvar_8;
  tmpvar_8 = texture (TEXTURE_BACKG_RGB, xlv_TEXCOORD2).xyz;
  blendColorRGB_5 = tmpvar_8;
  lowp float tmpvar_9;
  tmpvar_9 = texture (TEXTURE_BACKG_ALPHA, xlv_TEXCOORD2).x;
  blendColorAlpha_4 = tmpvar_9;
  if ((blendColorRGB_5.x < 0.5)) {
    r_3 = ((2.0 * blendColorRGB_5.x) * baseColor_6.x);
  } else {
    r_3 = (1.0 - ((
      (1.0 - blendColorRGB_5.x)
     * 
      (1.0 - baseColor_6.x)
    ) * 2.0));
  };
  if ((blendColorRGB_5.y < 0.5)) {
    g_2 = ((2.0 * blendColorRGB_5.y) * baseColor_6.y);
  } else {
    g_2 = (1.0 - ((
      (1.0 - blendColorRGB_5.y)
     * 
      (1.0 - baseColor_6.y)
    ) * 2.0));
  };
  if ((blendColorRGB_5.z < 0.5)) {
    b_1 = ((2.0 * blendColorRGB_5.z) * baseColor_6.z);
  } else {
    b_1 = (1.0 - ((
      (1.0 - blendColorRGB_5.z)
     * 
      (1.0 - baseColor_6.z)
    ) * 2.0));
  };
  highp vec4 tmpvar_10;
  tmpvar_10.w = 1.0;
  tmpvar_10.x = r_3;
  tmpvar_10.y = g_2;
  tmpvar_10.z = b_1;
  highp vec4 tmpvar_11;
  tmpvar_11 = ((tmpvar_10 * blendColorAlpha_4) + (baseColor_6 * (1.0 - blendColorAlpha_4)));
  _glesFragData[0] = tmpvar_11;
}

]===],
	},
}

end
