
function DefineParams()
	Properties = 
	{
		
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "facechangeeyeshadow3"
RenderQueue = "Opaque+100"
end

function Always()

COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_FACETEXPARA",
				varType = "float4",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "TEXTURE_DIFFUSE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEXTURE_BACKG",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_ALPHACOF",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
in vec4 _glesMultiTexCoord2;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
uniform highp vec4 UNIFORM_FACETEXPARA;
out highp vec2 xlv_TEXCOORD0;
out highp vec2 xlv_TEXCOORD1;
out highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec4 tmpvar_1;
  tmpvar_1.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_1.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_2;
  tmpvar_2.x = _glesVertex.x;
  tmpvar_2.y = -(_glesVertex.y);
  gl_Position = (tmpvar_1 * _glesVertex);
  xlv_TEXCOORD0 = _glesMultiTexCoord0.xy;
  xlv_TEXCOORD1 = ((vec2(1.0, 1.0) + tmpvar_2) / 2.0);
  xlv_TEXCOORD2 = ((_glesMultiTexCoord2.xy * UNIFORM_FACETEXPARA.xy) + UNIFORM_FACETEXPARA.zw);
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform sampler2D TEXTURE_DIFFUSE;
uniform sampler2D TEXTURE_BACKG;
uniform highp float UNIFORM_ALPHACOF;
in highp vec2 xlv_TEXCOORD1;
in highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp float b_1;
  highp float g_2;
  highp float r_3;
  highp vec4 blendColor_4;
  highp vec4 baseColor_5;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture (TEXTURE_DIFFUSE, xlv_TEXCOORD1);
  baseColor_5 = tmpvar_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture (TEXTURE_BACKG, xlv_TEXCOORD2);
  blendColor_4 = tmpvar_7;
  if ((blendColor_4.x < 0.5)) {
    r_3 = ((2.0 * blendColor_4.x) * baseColor_5.x);
  } else {
    r_3 = (1.0 - ((
      (1.0 - blendColor_4.x)
     * 
      (1.0 - baseColor_5.x)
    ) * 2.0));
  };
  if ((blendColor_4.y < 0.5)) {
    g_2 = ((2.0 * blendColor_4.y) * baseColor_5.y);
  } else {
    g_2 = (1.0 - ((
      (1.0 - blendColor_4.y)
     * 
      (1.0 - baseColor_5.y)
    ) * 2.0));
  };
  if ((blendColor_4.z < 0.5)) {
    b_1 = ((2.0 * blendColor_4.z) * baseColor_5.z);
  } else {
    b_1 = (1.0 - ((
      (1.0 - blendColor_4.z)
     * 
      (1.0 - baseColor_5.z)
    ) * 2.0));
  };
  highp vec4 tmpvar_8;
  tmpvar_8.w = 1.0;
  tmpvar_8.x = r_3;
  tmpvar_8.y = g_2;
  tmpvar_8.z = b_1;
  highp vec4 tmpvar_9;
  tmpvar_9 = min (((
    (tmpvar_8 * blendColor_4.w)
   * UNIFORM_ALPHACOF) + (baseColor_5 * 
    (1.0 - (blendColor_4.w * UNIFORM_ALPHACOF))
  )), vec4(1.0, 1.0, 1.0, 1.0));
  _glesFragData[0] = tmpvar_9;
}

]===],
	},
}

end
