
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
UNIFORM_ALPHACOF = { "Alpha Cofactor", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "facechangeblush"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, DST_COLOR, ZERO, ONE, ONE}
DRAW_MODE =  { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float2 uvstd : TEXCOORD2;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 texCoord : TEXCOORD0;
	float2 texCoordBag : TEXCOORD1;
	float2 texCoordStd : TEXCOORD2;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BACKG;
float4 UNIFORM_FACETEXPARA;
float UNIFORM_ALPHACOF;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.texCoord = v.uv;
	float2 flipVertex = float2(v.vertex.x, -v.vertex.y);
	o.texCoordBag = (float2(1.0, 1.0) + flipVertex) / 2.0;
	o.texCoordStd = v.uvstd * float2(UNIFORM_FACETEXPARA.x, UNIFORM_FACETEXPARA.y)
								+ float2(UNIFORM_FACETEXPARA.z, UNIFORM_FACETEXPARA.w);
	return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 baseColor = tex2D(TEXTURE_DIFFUSE, i.texCoordBag);
	float4 blendColor = tex2D(TEXTURE_BACKG, i.texCoordStd);
	float4 resColor = min(blendColor*blendColor.a*UNIFORM_ALPHACOF
							+ (1.0-blendColor.a*UNIFORM_ALPHACOF)*float4(1.0,1.0,1.0,1.0),1.0);
    return resColor;
}
ENDCG
#END
