
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
TEXTURE_REFLECTION = { "reflection tex", TEXTURE2D, "white" },
UNIFORM_REFFACTOR = { "reffactor", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "nl_reflection"
RenderQueue = "Opaque+100"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

uniform float3x3 LOCALWORLD_ROTATION;
sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_REFLECTION;
float UNIFORM_REFFACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv.xy;
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal = mul(LOCALWORLD_ROTATION, v.normal).xyz;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float3 viewDir = normalize(float3(i.worldpos.xyz) - CAMERA_WORLDPOSITION);
	float3 reflectDir = reflect(viewDir, normalize(i.worldnormal));
	float4 color = tex2D(TEXTURE_REFLECTION, reflectDir.xy)*UNIFORM_REFFACTOR;
	color.a = 0.0;
  	float4 color2 = tex2D(TEXTURE_DIFFUSE, i.uv)+color;
	
	return color2;
}
ENDCG
#END
