
function DefineParams()
	Properties = 
	{
		
UNIFORM_INPUT_TEXTURE         = {"UNIFORM_INPUT_TEXTURE",         TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
UNIFORM_BLUR_TEXTURE          = {"UNIFORM_BLUR_TEXTURE",          TEXTURE2D, "UNIFORM_BLUR_TEXTURE"},
UNIFORM_BLUR_TEXTURE2         = {"UNIFORM_BLUR_TEXTURE2",         TEXTURE2D, "UNIFORM_BLUR_TEXTURE2"},
UNIFORM_MASK_TEXTURE          = {"UNIFORM_MASK_TEXTURE",          TEXTURE2D, "UNIFORM_MASK_TEXTURE"},
UNIFORM_EYE_MASK_TEXTURE      = {"UNIFORM_EYE_MASK_TEXTURE",      TEXTURE2D, "UNIFORM_EYE_MASK_TEXTURE"},
UNIFORM_TEETH_LOOKUP_TEXTURE  = {"UNIFORM_TEETH_LOOKUP_TEXTURE",  TEXTURE2D, "UNIFORM_TEETH_LOOKUP_TEXTURE"},
UNIFORM_BRIGHT_EYE_STRENGTH   = {"UNIFORM_BRIGHT_EYE_STRENGTH",   FLOAT, "0.0"},
UNIFORM_NAOLABIAL_STRENGTH    = {"UNIFORM_NAOLABIAL_STRENGTH",    FLOAT, "0.0"},
UNIFORM_EYEBAG_STRENGTH       = {"UNIFORM_EYEBAG_STRENGTH",       FLOAT, "0.0"},
UNIFORM_WHITEN_TEETH_STRENGTH = {"UNIFORM_WHITEN_TEETH_STRENGTH", FLOAT, "0.0"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName  = "face_beauty"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles2",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			{
				varName = "DEVICE_COORDINATE_Y_FLIP",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "UNIFORM_INPUT_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BLUR_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BLUR_TEXTURE2",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EYE_MASK_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_TEETH_LOOKUP_TEXTURE",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_BRIGHT_EYE_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_NAOLABIAL_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_EYEBAG_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "UNIFORM_WHITEN_TEETH_STRENGTH",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[attribute vec4 _glesVertex;
attribute vec4 _glesMultiTexCoord0;
uniform highp float DEVICE_COORDINATE_Y_FLIP;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  highp vec3 tmpvar_1;
  tmpvar_1 = _glesVertex.xyz;
  highp vec2 tmpvar_2;
  tmpvar_2.x = (0.5 * (_glesVertex.x + 1.0));
  tmpvar_2.y = (1.0 - (0.5 * (_glesVertex.y + 1.0)));
  highp vec4 tmpvar_3;
  tmpvar_3.zw = vec2(0.0, 1.0);
  tmpvar_3.xy = tmpvar_1.xy;
  highp vec4 tmpvar_4;
  tmpvar_4.xzw = vec3(1.0, 1.0, 1.0);
  tmpvar_4.y = DEVICE_COORDINATE_Y_FLIP;
  highp vec2 tmpvar_5;
  tmpvar_5.y = 0.0;
  tmpvar_5.x = tmpvar_1.z;
  xlv_TEXCOORD0 = tmpvar_2;
  xlv_TEXCOORD1 = _glesMultiTexCoord0.xy;
  gl_Position = (tmpvar_4 * tmpvar_3);
  xlv_TEXCOORD2 = tmpvar_5;
}

]===],
		psShader = [===[uniform sampler2D UNIFORM_INPUT_TEXTURE;
uniform sampler2D UNIFORM_BLUR_TEXTURE;
uniform sampler2D UNIFORM_BLUR_TEXTURE2;
uniform sampler2D UNIFORM_MASK_TEXTURE;
uniform sampler2D UNIFORM_EYE_MASK_TEXTURE;
uniform sampler2D UNIFORM_TEETH_LOOKUP_TEXTURE;
uniform highp float UNIFORM_BRIGHT_EYE_STRENGTH;
uniform highp float UNIFORM_NAOLABIAL_STRENGTH;
uniform highp float UNIFORM_EYEBAG_STRENGTH;
uniform highp float UNIFORM_WHITEN_TEETH_STRENGTH;
highp float xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH;
varying highp vec2 xlv_TEXCOORD0;
varying highp vec2 xlv_TEXCOORD1;
varying highp vec2 xlv_TEXCOORD2;
void main ()
{
  xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH = UNIFORM_BRIGHT_EYE_STRENGTH;
  highp vec4 eyeMaskColor_1;
  highp vec4 maskColor_2;
  highp vec3 resultColor_3;
  highp vec4 sourceColor_4;
  lowp vec4 tmpvar_5;
  tmpvar_5 = texture2D (UNIFORM_INPUT_TEXTURE, xlv_TEXCOORD0);
  sourceColor_4 = tmpvar_5;
  resultColor_3 = sourceColor_4.xyz;
  lowp vec4 tmpvar_6;
  tmpvar_6 = texture2D (UNIFORM_MASK_TEXTURE, xlv_TEXCOORD1);
  maskColor_2 = tmpvar_6;
  lowp vec4 tmpvar_7;
  tmpvar_7 = texture2D (UNIFORM_EYE_MASK_TEXTURE, xlv_TEXCOORD1);
  eyeMaskColor_1 = tmpvar_7;
  if ((((maskColor_2.x > 0.01) && (maskColor_2.z < 0.01)) && (UNIFORM_BRIGHT_EYE_STRENGTH >= 0.01))) {
    highp vec3 sumColor_8;
    lowp vec4 tmpvar_9;
    highp vec2 P_10;
    highp vec2 tmpvar_11;
    tmpvar_11 = (xlv_TEXCOORD0 + vec2(-0.008000602, -0.0));
    P_10 = (tmpvar_11 + vec2(-0.0, -0.008000602));
    tmpvar_9 = texture2D (UNIFORM_INPUT_TEXTURE, P_10);
    sumColor_8 = tmpvar_9.xyz;
    lowp vec4 tmpvar_12;
    highp vec2 P_13;
    P_13 = (tmpvar_11 + vec2(-0.0, -0.004000301));
    tmpvar_12 = texture2D (UNIFORM_INPUT_TEXTURE, P_13);
    sumColor_8 = (sumColor_8 + tmpvar_12.xyz);
    lowp vec4 tmpvar_14;
    tmpvar_14 = texture2D (UNIFORM_INPUT_TEXTURE, tmpvar_11);
    sumColor_8 = (sumColor_8 + tmpvar_14.xyz);
    lowp vec4 tmpvar_15;
    highp vec2 P_16;
    P_16 = (tmpvar_11 + vec2(0.0, 0.004000301));
    tmpvar_15 = texture2D (UNIFORM_INPUT_TEXTURE, P_16);
    sumColor_8 = (sumColor_8 + tmpvar_15.xyz);
    lowp vec4 tmpvar_17;
    highp vec2 P_18;
    P_18 = (tmpvar_11 + vec2(0.0, 0.008000602));
    tmpvar_17 = texture2D (UNIFORM_INPUT_TEXTURE, P_18);
    sumColor_8 = (sumColor_8 + tmpvar_17.xyz);
    lowp vec4 tmpvar_19;
    highp vec2 P_20;
    highp vec2 tmpvar_21;
    tmpvar_21 = (xlv_TEXCOORD0 + vec2(-0.004000301, -0.0));
    P_20 = (tmpvar_21 + vec2(-0.0, -0.008000602));
    tmpvar_19 = texture2D (UNIFORM_INPUT_TEXTURE, P_20);
    sumColor_8 = (sumColor_8 + tmpvar_19.xyz);
    lowp vec4 tmpvar_22;
    highp vec2 P_23;
    P_23 = (tmpvar_21 + vec2(-0.0, -0.004000301));
    tmpvar_22 = texture2D (UNIFORM_INPUT_TEXTURE, P_23);
    sumColor_8 = (sumColor_8 + tmpvar_22.xyz);
    lowp vec4 tmpvar_24;
    tmpvar_24 = texture2D (UNIFORM_INPUT_TEXTURE, tmpvar_21);
    sumColor_8 = (sumColor_8 + tmpvar_24.xyz);
    lowp vec4 tmpvar_25;
    highp vec2 P_26;
    P_26 = (tmpvar_21 + vec2(0.0, 0.004000301));
    tmpvar_25 = texture2D (UNIFORM_INPUT_TEXTURE, P_26);
    sumColor_8 = (sumColor_8 + tmpvar_25.xyz);
    lowp vec4 tmpvar_27;
    highp vec2 P_28;
    P_28 = (tmpvar_21 + vec2(0.0, 0.008000602));
    tmpvar_27 = texture2D (UNIFORM_INPUT_TEXTURE, P_28);
    sumColor_8 = (sumColor_8 + tmpvar_27.xyz);
    lowp vec4 tmpvar_29;
    highp vec2 P_30;
    P_30 = (xlv_TEXCOORD0 + vec2(-0.0, -0.008000602));
    tmpvar_29 = texture2D (UNIFORM_INPUT_TEXTURE, P_30);
    sumColor_8 = (sumColor_8 + tmpvar_29.xyz);
    lowp vec4 tmpvar_31;
    highp vec2 P_32;
    P_32 = (xlv_TEXCOORD0 + vec2(-0.0, -0.004000301));
    tmpvar_31 = texture2D (UNIFORM_INPUT_TEXTURE, P_32);
    sumColor_8 = (sumColor_8 + tmpvar_31.xyz);
    lowp vec4 tmpvar_33;
    tmpvar_33 = texture2D (UNIFORM_INPUT_TEXTURE, xlv_TEXCOORD0);
    sumColor_8 = (sumColor_8 + tmpvar_33.xyz);
    lowp vec4 tmpvar_34;
    highp vec2 P_35;
    P_35 = (xlv_TEXCOORD0 + vec2(0.0, 0.004000301));
    tmpvar_34 = texture2D (UNIFORM_INPUT_TEXTURE, P_35);
    sumColor_8 = (sumColor_8 + tmpvar_34.xyz);
    lowp vec4 tmpvar_36;
    highp vec2 P_37;
    P_37 = (xlv_TEXCOORD0 + vec2(0.0, 0.008000602));
    tmpvar_36 = texture2D (UNIFORM_INPUT_TEXTURE, P_37);
    sumColor_8 = (sumColor_8 + tmpvar_36.xyz);
    lowp vec4 tmpvar_38;
    highp vec2 P_39;
    highp vec2 tmpvar_40;
    tmpvar_40 = (xlv_TEXCOORD0 + vec2(0.004000301, 0.0));
    P_39 = (tmpvar_40 + vec2(-0.0, -0.008000602));
    tmpvar_38 = texture2D (UNIFORM_INPUT_TEXTURE, P_39);
    sumColor_8 = (sumColor_8 + tmpvar_38.xyz);
    lowp vec4 tmpvar_41;
    highp vec2 P_42;
    P_42 = (tmpvar_40 + vec2(-0.0, -0.004000301));
    tmpvar_41 = texture2D (UNIFORM_INPUT_TEXTURE, P_42);
    sumColor_8 = (sumColor_8 + tmpvar_41.xyz);
    lowp vec4 tmpvar_43;
    tmpvar_43 = texture2D (UNIFORM_INPUT_TEXTURE, tmpvar_40);
    sumColor_8 = (sumColor_8 + tmpvar_43.xyz);
    lowp vec4 tmpvar_44;
    highp vec2 P_45;
    P_45 = (tmpvar_40 + vec2(0.0, 0.004000301));
    tmpvar_44 = texture2D (UNIFORM_INPUT_TEXTURE, P_45);
    sumColor_8 = (sumColor_8 + tmpvar_44.xyz);
    lowp vec4 tmpvar_46;
    highp vec2 P_47;
    P_47 = (tmpvar_40 + vec2(0.0, 0.008000602));
    tmpvar_46 = texture2D (UNIFORM_INPUT_TEXTURE, P_47);
    sumColor_8 = (sumColor_8 + tmpvar_46.xyz);
    lowp vec4 tmpvar_48;
    highp vec2 P_49;
    highp vec2 tmpvar_50;
    tmpvar_50 = (xlv_TEXCOORD0 + vec2(0.008000602, 0.0));
    P_49 = (tmpvar_50 + vec2(-0.0, -0.008000602));
    tmpvar_48 = texture2D (UNIFORM_INPUT_TEXTURE, P_49);
    sumColor_8 = (sumColor_8 + tmpvar_48.xyz);
    lowp vec4 tmpvar_51;
    highp vec2 P_52;
    P_52 = (tmpvar_50 + vec2(-0.0, -0.004000301));
    tmpvar_51 = texture2D (UNIFORM_INPUT_TEXTURE, P_52);
    sumColor_8 = (sumColor_8 + tmpvar_51.xyz);
    lowp vec4 tmpvar_53;
    tmpvar_53 = texture2D (UNIFORM_INPUT_TEXTURE, tmpvar_50);
    sumColor_8 = (sumColor_8 + tmpvar_53.xyz);
    lowp vec4 tmpvar_54;
    highp vec2 P_55;
    P_55 = (tmpvar_50 + vec2(0.0, 0.004000301));
    tmpvar_54 = texture2D (UNIFORM_INPUT_TEXTURE, P_55);
    sumColor_8 = (sumColor_8 + tmpvar_54.xyz);
    lowp vec4 tmpvar_56;
    highp vec2 P_57;
    P_57 = (tmpvar_50 + vec2(0.0, 0.008000602));
    tmpvar_56 = texture2D (UNIFORM_INPUT_TEXTURE, P_57);
    sumColor_8 = (sumColor_8 + tmpvar_56.xyz);
    sumColor_8 = (sumColor_8 * 0.04);
    highp vec3 tmpvar_58;
    tmpvar_58 = max (sourceColor_4.xyz, clamp ((sumColor_8 + 
      ((sourceColor_4.xyz - sumColor_8) * 3.0)
    ), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)));
    sumColor_8 = tmpvar_58;
    xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH = (UNIFORM_BRIGHT_EYE_STRENGTH * xlv_TEXCOORD2.x);
    highp vec3 tmpvar_59;
    tmpvar_59 = mix (sourceColor_4.xyz, tmpvar_58, vec3(((xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH * 0.5) * maskColor_2.x)));
    resultColor_3 = mix (mix (tmpvar_59, clamp (
      (((tmpvar_59 * tmpvar_59) * -0.3543) + (1.354 * tmpvar_59))
    , vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)), vec3((
      (eyeMaskColor_1.y * xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH)
     * 0.5))), clamp ((
      ((tmpvar_59 * tmpvar_59) * 0.3401)
     + 
      (0.6599 * tmpvar_59)
    ), vec3(0.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0)), vec3(((eyeMaskColor_1.z * xlat_mutableUNIFORM_BRIGHT_EYE_STRENGTH) * 0.5)));
  } else {
    if (((maskColor_2.y > 0.01) && (UNIFORM_EYEBAG_STRENGTH >= 0.01))) {
      highp vec3 blurColor2_60;
      highp vec3 blurColor1_61;
      lowp vec3 tmpvar_62;
      tmpvar_62 = texture2D (UNIFORM_BLUR_TEXTURE, xlv_TEXCOORD0).xyz;
      blurColor1_61 = tmpvar_62;
      lowp vec3 tmpvar_63;
      tmpvar_63 = texture2D (UNIFORM_BLUR_TEXTURE2, xlv_TEXCOORD0).xyz;
      blurColor2_60 = tmpvar_63;
      resultColor_3 = mix (sourceColor_4.xyz, min ((sourceColor_4.xyz + 
        clamp ((((blurColor2_60 - blurColor1_61) * 1.3) + (0.03 * blurColor2_60)), vec3(0.0, 0.0, 0.0), vec3(0.2, 0.2, 0.2))
      ), vec3(1.0, 1.0, 1.0)), vec3((UNIFORM_EYEBAG_STRENGTH * maskColor_2.y)));
    } else {
      if ((((maskColor_2.z > 0.01) && (maskColor_2.x < 0.01)) && (UNIFORM_NAOLABIAL_STRENGTH >= 0.01))) {
        highp vec3 blurColor2_1_64;
        highp vec3 blurColor1_1_65;
        lowp vec3 tmpvar_66;
        tmpvar_66 = texture2D (UNIFORM_BLUR_TEXTURE, xlv_TEXCOORD0).xyz;
        blurColor1_1_65 = tmpvar_66;
        lowp vec3 tmpvar_67;
        tmpvar_67 = texture2D (UNIFORM_BLUR_TEXTURE2, xlv_TEXCOORD0).xyz;
        blurColor2_1_64 = tmpvar_67;
        resultColor_3 = mix (sourceColor_4.xyz, min ((sourceColor_4.xyz + 
          clamp ((((blurColor2_1_64 - blurColor1_1_65) * 1.4) + (0.05 * blurColor2_1_64)), vec3(0.0, 0.0, 0.0), vec3(0.3, 0.3, 0.3))
        ), vec3(1.0, 1.0, 1.0)), vec3((UNIFORM_NAOLABIAL_STRENGTH * maskColor_2.z)));
      } else {
        if ((((maskColor_2.z > 0.01) && (maskColor_2.x > 0.01)) && (UNIFORM_WHITEN_TEETH_STRENGTH >= 0.01))) {
          highp vec3 newColor2_68;
          highp vec3 newColor1_69;
          highp vec2 texPos2_70;
          highp vec2 texPos1_71;
          highp vec2 quad2_72;
          highp vec2 quad1_73;
          highp float tmpvar_74;
          tmpvar_74 = (sourceColor_4.z * 15.0);
          quad1_73.y = floor((floor(tmpvar_74) * 0.25));
          quad1_73.x = (floor(tmpvar_74) - (quad1_73.y * 4.0));
          quad2_72.y = floor((ceil(tmpvar_74) * 0.25));
          quad2_72.x = (ceil(tmpvar_74) - (quad2_72.y * 4.0));
          texPos1_71 = (((quad1_73 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * sourceColor_4.xy));
          texPos2_70 = (((quad2_72 * vec2(0.25, 0.25)) + vec2(0.0078125, 0.0078125)) + (vec2(0.234375, 0.234375) * sourceColor_4.xy));
          lowp vec3 tmpvar_75;
          tmpvar_75 = texture2D (UNIFORM_TEETH_LOOKUP_TEXTURE, texPos1_71).xyz;
          newColor1_69 = tmpvar_75;
          lowp vec3 tmpvar_76;
          tmpvar_76 = texture2D (UNIFORM_TEETH_LOOKUP_TEXTURE, texPos2_70).xyz;
          newColor2_68 = tmpvar_76;
          resultColor_3 = mix (sourceColor_4.xyz, mix (newColor1_69, newColor2_68, vec3(fract(tmpvar_74))), vec3((UNIFORM_WHITEN_TEETH_STRENGTH * maskColor_2.z)));
        };
      };
    };
  };
  highp vec4 tmpvar_77;
  tmpvar_77.xyz = resultColor_3;
  tmpvar_77.w = sourceColor_4.w;
  gl_FragData[0] = tmpvar_77;
}

]===],
	},
}

end