
#DEFPARAMS
UNIFORM_INPUT_TEXTURE       = {"UNIFORM_INPUT_TEXTURE", TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
UNIFORM_TEXEL_WIDTH_OFFSET  = {"UNIFORM_TEXEL_WIDTH_OFFSET", FLOAT, "0.0"},
UNIFORM_TEXEL_HEIGHT_OFFSET = {"UNIFORM_TEXEL_HEIGHT_OFFSET", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "box_blur"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float2 in_pos : POSITION;
    float2 in_tex_coord : TEXCOORD0;
};

struct v2f
{
    float2 out_tex_coord : TEXCOORD0;
    float4 out_tex_shift1 : TEXCOORD1;
    float4 out_tex_shift2 : TEXCOORD2;
    float4 out_pos : SV_POSITION;
};

float UNIFORM_TEXEL_WIDTH_OFFSET;
float UNIFORM_TEXEL_HEIGHT_OFFSET;

v2f vert(appdata v)
{
#define texel_width_offset UNIFORM_TEXEL_WIDTH_OFFSET
#define texel_height_offset UNIFORM_TEXEL_HEIGHT_OFFSET
    v2f o;
    o.out_tex_coord           = v.in_tex_coord;;
    o.out_pos                 = UniformNDC(float4(v.in_pos.x, v.in_pos.y, 0.0, 1.0));
    float2 single_step_offset = float2(texel_width_offset, texel_height_offset);
    o.out_tex_shift1          = float4(o.out_tex_coord - single_step_offset, o.out_tex_coord + single_step_offset);
    o.out_tex_shift2          = float4(o.out_tex_coord - 2.0 * single_step_offset, o.out_tex_coord + 2.0 * single_step_offset);
    return o;
}

sampler2D UNIFORM_INPUT_TEXTURE;

float4 frag(v2f i) : SV_Target
{
#define input_texture UNIFORM_INPUT_TEXTURE
    float3 sum = tex2D(input_texture, i.out_tex_coord).xyz;
    sum += tex2D(input_texture, i.out_tex_shift1.xy).xyz;
    sum += tex2D(input_texture, i.out_tex_shift1.zw).xyz;
    sum += tex2D(input_texture, i.out_tex_shift2.xy).xyz;
    sum += tex2D(input_texture, i.out_tex_shift2.zw).xyz;
    sum = sum * 0.2;
    return float4(sum, 1.0);
}

ENDCG
#END