//@author      : Zhu Fei
//@date        : 2019-06-26
//@description : shader to generate patch image for line effect
//@version     : 1.0

#SHADER_DEFINE CreatePatchImageVertex
    FUNCTION_INPUT =
    {
        {ATTRIBUTE_POSITION,    HIGH, VEC4, "in_pos"},
        {ATTRIBUTE_COORDNATE0, HIGH, VEC2, "in_tex_coord"},
    }
    FUNCTION_OUTPUT =
    {
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2, "out_tex_coord"}
    }

#SHADER_CODE
    gl_Position        = in_pos;
    vec2 out_tex_coord = in_tex_coord;
#END_CODE

#END_DEFINE

#SHADER_DEFINE CreatePatchImageFragment
    FUNCTION_INPUT =
    {
        {ATTRIBUTE_COORDNATE1, HIGH, VEC2,      "in_tex_coord"},
        {PATCH_SIZE,            HIGH, FLOAT,     "in_patch_size"},
        {FRAME_IMG,             NONE, TEXTURE2D, "in_high_res_img"},
        {TEX_COORD_OFFSET,      HIGH, VEC2,      "in_tex_coord_offset"}
    }

#SHADER_CODE
    float   patch_pixel_num = 0.0;
    float patch_pixel_intensity = 0.0;
    vec2  patch_pixel = in_tex_coord;
    vec3  pixel_rgb = vec3(0.0, 0.0, 0.0);
    for(float offset_x = 0.0; offset_x < in_patch_size; offset_x += 1.0)
    {
        patch_pixel.x = in_tex_coord.x + offset_x * in_tex_coord_offset.x;
        if(patch_pixel.x > 1.0)
            break;
        
        for(float offset_y = 0.0; offset_y < in_patch_size; offset_y += 1.0)
        {
            patch_pixel.y = in_tex_coord.y + offset_y * in_tex_coord_offset.y;
            if(patch_pixel.y > 1.0)
                break;
            
            pixel_rgb = texture2D(in_high_res_img, patch_pixel).rgb;
            patch_pixel_intensity += (0.299 * pixel_rgb.r + 0.587 * pixel_rgb.g + 0.114 * pixel_rgb.b);
            patch_pixel_num += 1.0;
        }
    }
    if(patch_pixel_num > 0.0)
        patch_pixel_intensity /= patch_pixel_num;
    
    gl_FragColor = vec4(patch_pixel_intensity);
#END_CODE

#END_DEFINE