
function DefineParams()
	Properties = 
	{
		
PATCH_SIZE = {"PATCH_SIZE", FLOAT, "15.0"},
TEX_COORD_OFFSET = {"TEX_COORD_OFFSET", VEC2, "0.1, 0.1"},
FRAME_IMG = {"FRAME_IMG", TEXTURE2D, "FRAME_IMG"},

	}
	Attributes = 
	{
	}
	
end



function Init()
	PassNames = 
	{
		"Always"
	}

ShaderName = "CreatePatchImg"
RenderQueue = "Transparent"
end

function Always()

COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = {ALPAH_OFF}
DRAW_MODE    = {CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF}
STENCIL_MODE = {STENCIL_OFF}


Programs =
{
	{
		shaderApi = "gles3",
		keyWords = {},
		vsBufferSize = "0",
		vsAttributes = {
		},
		vsUniforms = {
			},
		psBufferSize = "0",
		psUniforms = {
			{
				varName = "PATCH_SIZE",
				varType = "float",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "TEX_COORD_OFFSET",
				varType = "float2",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			{
				varName = "FRAME_IMG",
				varType = "sampler2D",
				varSit = "",
				varNum = "1",
				varRegIndex = "0",
				varRegCount = "1",
			},
			},
		vsShader = [===[#version 300 es
in vec4 _glesVertex;
in vec4 _glesMultiTexCoord0;
out highp vec2 xlv_TEXCOORD1;
void main ()
{
  xlv_TEXCOORD1 = _glesMultiTexCoord0.xy;
  gl_Position = _glesVertex;
}

]===],
		psShader = [===[#version 300 es
layout(location=0) out mediump vec4 _glesFragData[1];
uniform highp float PATCH_SIZE;
uniform highp vec2 TEX_COORD_OFFSET;
uniform sampler2D FRAME_IMG;
in highp vec2 xlv_TEXCOORD1;
void main ()
{
  highp vec2 tmpvar_1;
  tmpvar_1 = xlv_TEXCOORD1;
  highp vec3 pixel_rgb_3;
  highp vec2 patch_pixel_4;
  highp float patch_pixel_intensity_5;
  highp float patch_pixel_num_6;
  patch_pixel_num_6 = 0.0;
  patch_pixel_intensity_5 = 0.0;
  patch_pixel_4 = xlv_TEXCOORD1;
  pixel_rgb_3 = vec3(0.0, 0.0, 0.0);
  for (highp float offset_x_2 = 0.0; offset_x_2 < PATCH_SIZE; offset_x_2 += 1.0) {
    patch_pixel_4.x = (tmpvar_1.x + (offset_x_2 * TEX_COORD_OFFSET.x));
    if ((patch_pixel_4.x > 1.0)) {
      break;
    };
    for (highp float offset_y_7 = 0.0; offset_y_7 < PATCH_SIZE; offset_y_7 += 1.0) {
      patch_pixel_4.y = (tmpvar_1.y + (offset_y_7 * TEX_COORD_OFFSET.y));
      if ((patch_pixel_4.y > 1.0)) {
        break;
      };
      lowp vec4 tmpvar_8;
      tmpvar_8 = textureLod (FRAME_IMG, patch_pixel_4, 0.0);
      pixel_rgb_3 = tmpvar_8.xyz;
      patch_pixel_intensity_5 = (patch_pixel_intensity_5 + ((
        (0.299 * pixel_rgb_3.x)
       + 
        (0.587 * pixel_rgb_3.y)
      ) + (0.114 * pixel_rgb_3.z)));
      patch_pixel_num_6 += 1.0;
    };
  };
  if ((patch_pixel_num_6 > 0.0)) {
    patch_pixel_intensity_5 = (patch_pixel_intensity_5 / patch_pixel_num_6);
  };
  highp vec4 tmpvar_9;
  tmpvar_9.x = patch_pixel_intensity_5;
  tmpvar_9.y = patch_pixel_intensity_5;
  tmpvar_9.z = patch_pixel_intensity_5;
  tmpvar_9.w = patch_pixel_intensity_5;
  _glesFragData[0] = tmpvar_9;
}

]===],
	},
}

end
