/**
 * WebView JSON error tracking injection
 * Monitors JSON.parse and JSON.stringify operations for errors
 * Reports errors through BrowserHost bridge
 */

if (this.isMissingJSON) {
    window.BrowserHost.emitJSONMissingMetric();
}

// Store the original methods
const originalStringify = JSON.stringify;
const originalParse = JSON.parse;

// Override JSON.stringify
JSON.stringify = function(...args) {
    try {
        return originalStringify.apply(JSON, args);
    } catch (error) {
        window.BrowserHost.emitJSONErrorMetric();
        throw error;
    }
};

// Override JSON.parse
JSON.parse = function(...args) {
    try {
        return originalParse.apply(JSON, args);
    } catch (error) {
        window.BrowserHost.emitJSONErrorMetric();
        throw error;
    }
};