local vc = require "libvenuscore"

local function ProfileScope(func, name)
  if _ENABLED_VENUS_PROFILER then
    local handle = vc.VenusProfiler:RegisterScopeName(name)
    local wrapper = function(...)
      local scope = vc.VenusProfiler:EnterScope(handle)
      local res = { func(...) }
      scope:ExitScope()
      return unpack(res)
    end
    return wrapper
  else
    return func
  end
end

return ProfileScope
