local basetype = require "venuscore.rtti.types.basetype"


local ComboType = basetype:extend("ComboType");


function ComboType:new(comboSource, get, set)
  ComboType.super.new(self, get, set);
  local comboSourceType = type(comboSource);
  if comboSourceType == "function" then
    self.funcGetComboData = comboSource;
  elseif comboSourceType == "table" then
    self.funcGetComboData = function(obj)
      return comboSource;
    end;
  end
end


function ComboType:GetComboData(obj)
  return self.funcGetComboData(obj)
end

--
function ComboType:SetData(keys, values) -- 前面存C++枚举值(从0开始要加多一个1) 后面存表示C++枚举的字符串
  local comboSource = {};
  for k,v in pairs(keys) do
    comboSource[v] = values[k]
  end
  self.funcGetComboData = function(obj)
    return comboSource;
  end
end

function ComboType:SetDataFunction(func)
  self.funcGetComboData = func;
end

function ComboType:ChangeData(data)

end

return ComboType;