local basetype = require "venuscore.rtti.types.basetype"
local BD = require "bluecore.bluedefined"

local BlueprintType = basetype:extend("BluePrintType");

local objectExtend = BlueprintType.extend; --Object的extend函数地址

local gIndex = 1

function BlueprintType:extend(...)
  local clazz = objectExtend(self, ...)

  if BD.LEAK_DEBUG then
    local index = gIndex -- default INVALID_BLUEPRINT_TYPE +1
    gIndex = gIndex + 1
    self.index = index -- not used
    ERROR("^^^^^^^^^ BlueprintType new called:" ..tostring(index)..","..tostring(gIndex));
    local prox = newproxy(true)
    getmetatable(prox).__gc = function() ERROR("^^^^^^^^^ BlueprintType CG called:" ..tostring(index)); end
    clazz[prox] = true
  end

  return clazz ;
end

function BlueprintType:new()
  BlueprintType.super.new(self);
  self._ClassId = BlueprintType.INVALID_CLASS_ID
  self._ClassName = self._ClassId;
  error("BlueprintType:new() never called !");
end

function BlueprintType:InitClassInfo(clsId, clsName)
  self._ClassId = clsId
  self._ClassName = clsName
  WARNING("BlueprintClass = "..tostring(self._ClassId)..","..tostring(self._ClassName));
end

-- 使用这个来判断是否蓝图类的类型
function BlueprintType:GetClassId()
  return self._ClassId
end

function BlueprintType:IsSameClassId(classId)
  return self._ClassId == classId
end

function BlueprintType:UpdateDisplayName(name)
  self._ClassName = name ;
end

function BlueprintType:GetDisplayName()
  return self._ClassName ;
end

-- 标记这个蓝图类型是否是场景蓝图,场景蓝图类不能用于变量和函数参数
--  BlueScene:_OnDeserialize
--  BlueScene:_OnDeseria
function BlueprintType:SetSceneFlag()
  self._isSceneClass = true
end

function BlueprintType:IsSceneClass()
  return self._isSceneClass ~= nil and self._isSceneClass == true
end

-- Override
function BlueprintType:isType(type)
  if type == BlueprintType then
    return false
  end

  if not type.GetClassId then
    return false
  end

  if type:GetClassId() == self._ClassId then
    return true ;
  end

  return false ;
end

-- Override
function BlueprintType:isTypeOrDriverType(type)
  if type == BlueprintType then
    return true
  end
  return self:isType(type)
end

-- 无效的BlueprintType 代表被删除的类
local newRtti = BlueprintType:extend();
newRtti:InitClassInfo(BD.SIGNATURE .."0", BD.SIGNATURE .."0");

BlueprintType.INVALID_BLUEPRINT_TYPE = newRtti
BlueprintType.INVALID_CLASS_ID = BD.SIGNATURE .."0"
BlueprintType.INVALID_CLASS_NAME = BD.SIGNATURE .."0"

return BlueprintType;