local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local GetParamNamesCommand = CommandBase:extend("GetParamNamesCommand");

function GetParamNamesCommand:new(comuid, smsId)
    GetParamNamesCommand.super.new(self);
    self._comUid = comuid;
    self._smsId  = smsId;
    self._names  = nil;
end

function GetParamNamesCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        self._names = ani:GetParameterNames(self._smsId);
    end
    self:EndCmd();
end

function GetParamNamesCommand:Undo()
    self:BeginCmd();
    
    self:EndCmd();
end

return GetParamNamesCommand;