
local MemberIterator = require "venuscore.rtti.mpairs"
local RttiManager = require "venuscore.rtti.rttimanager"
local Serializer = require "venuscore.bundle.fserializer.fserializer"
local MSerializer = require "venuscore.bundle.mserializer.mserializer"
local FDatatype = require "venuscore.bundle.fserializer.fdatatype"
local SerializationTool = require "venuscore.bundle.serialization.serializationtool"
local libvenuscore = require "libvenuscore"

local BD = require "bluecore.bluedefined"
local apollocore = require "apollocore"
local venuscore = require "libvenuscore"
local bit = require("bit")

local PrefabTool = require "venuscore.bundle.serialization.prefabtool"
local venusjson = require "venusjson"

local BundleSystem = {}
local isPreView = false;
local EditorSceneName = "Scene"
BundleSystem.DeserializeMode =
{
  Prefab = 1,
  Scene = 2
};
BundleSystem.SerializeMode =
{
  Prefab = 1,
  Scene = 2
  --LibFunction = 3
};

BundleSystem.CurrentDeserializeMode = BundleSystem.DeserializeMode.Prefab;
BundleSystem.CurrentSerializeMode = BundleSystem.SerializeMode.Scene;
BundleSystem.CurrentScene = nil;

BundleSystem.Version = 2; --版本号

BundleSystem.SerializeDelegates = {};
BundleSystem.DeserializeDelegates = {};
BundleSystem.DeserializeInitDelegates = {};
BundleSystem.SerializeStartedDelegates = {}; --序列化开始的回调
BundleSystem.SerializeFinishedDelegates = {}; --序列化完成的回调
BundleSystem.DeserializeFinishedDelegates = {}; --反序列化完成的回调
BundleSystem.RegisterSerializationDelegates = {};
BundleSystem.RegisterDeserializationDelegates = {};

BundleSystem.SkipRootNodeForScene = false;
BundleSystem.PrefabChangeIDMap = {};
BundleSystem.SerializeByPrefab = true;

function BundleSystem:RegisterSerialization(typeName, func)
  assert(not BundleSystem.RegisterSerializationDelegates[typeName]);
  BundleSystem.RegisterSerializationDelegates[typeName] = func;
end

function BundleSystem:RegisterDeserialization(typeName, func)
  assert(not BundleSystem.RegisterDeserializationDelegates[typeName]);
  BundleSystem.RegisterDeserializationDelegates[typeName] = func;
end

function BundleSystem:GetDeserializationCallback(typeName)
  return BundleSystem.RegisterDeserializationDelegates[typeName] or BundleSystem.RegisterDeserializationDelegates["Default"];
end

function BundleSystem:OnSerialize(fieldname, func)
  assert(not BundleSystem.SerializeDelegates[fieldname]);
  BundleSystem.SerializeDelegates[fieldname] = func;
end    

function BundleSystem:OnDeserialize(typename, func)
  assert(not BundleSystem.DeserializeDelegates[typename]);
  BundleSystem.DeserializeDelegates[typename] = func;
end

function BundleSystem:OnDeserializeInit(typename, func)
  assert(not BundleSystem.DeserializeInitDelegates[typename]);
  BundleSystem.DeserializeInitDelegates[typename] = func;
end

function BundleSystem:OnSerializeStarted(typename, func)
  assert(not BundleSystem.SerializeStartedDelegates[typename]);
  BundleSystem.SerializeStartedDelegates[typename] = func;
end

function BundleSystem:OnSerializeFinished(typename, func)
  assert(not BundleSystem.SerializeFinishedDelegates[typename]);
  BundleSystem.SerializeFinishedDelegates[typename] = func;
end

function BundleSystem:OnDeserializeFinished(typename, func)
  assert(not BundleSystem.DeserializeFinishedDelegates[typename]);
  BundleSystem.DeserializeFinishedDelegates[typename] = func;
end


--测试打印table
function BundleSystem:ToStr(t,dometatables)
 local function basicToStr (o)
  if type(o) == "number" or type(o)=="boolean" then
   return tostring(o)
  elseif type(o) == "string" then
   return string.format("%q", o)
  else
   return tostring(o) --"nil"
  end
 end
 local strTG = {}
 --local basicToStr= basicSerialize --tostring
 if type(t) ~="table" then  return basicToStr(t) end
 local recG = 0
 local nameG="SELF"..recG
 local ancest ={}
 local function _ToStr(t,strT,rec,name)
  if ancest[t] then
   strT[#strT + 1]=ancest[t]
   return
  end
  rec = rec + 1
  ancest[t]=name
  strT[#strT + 1]='{'
  local count=0
  -------------
  --if t.name then strT[#strT + 1]=string.rep("\t",rec).."name:"..tostring(t.name) end
  ----------------
  for k,v in pairs(t) do
   count=count+1
   strT[#strT + 1]="\n"
   local kstr
   if type(k) == "table" then
    local name2=string.format("%s.KEY%d",name,count)
    strT[#strT + 1]=string.rep("\t",rec).."["
    local strTK = {}
    _ToStr(k,strTK,rec,name2)
    kstr=table.concat(strTK)
    strT[#strT + 1]=kstr.."]="
   else
    kstr = basicToStr(k)
    strT[#strT + 1]=string.rep("\t",rec).."["..kstr.."]="
   end
   
   if type(v) == "table" then
     local name2=string.format("%s[%s]",name,kstr)
     _ToStr(v,strT,rec,name2)
   else
    strT[#strT + 1]=basicToStr(v)
   end
  end
  if dometatables then
   local mt = getmetatable(t)
   if mt then
    local namemt = string.format("%s.METATABLE",name)
    local strMT = {}
    _ToStr(mt,strMT,rec,namemt)
    local metastr=table.concat(strMT)
    strT[#strT + 1] = "\n"..string.rep("\t",rec).."[METATABLE]="..metastr
   end
  end
  strT[#strT + 1]='}'
  rec = rec - 1
  return
 end
 _ToStr(t,strTG,recG,nameG)
 return table.concat(strTG)
end
function BundleSystem:prtable(...)
 for i=1, select('#', ...) do
  local t = select(i, ...)
  print(self:ToStr(t))
  print("\n")
 end
end

--把dependency带出去
--Unreal如果函数库引用了某一个图片资源 删除图片资源的时候会定位到哪里被引用 做一个提示
function BundleSystem:SerialzeLibFunction(libFunc, serializeMode)
  --标记一下模式 暂时没用到
  --BundleSystem.CurrentSerializeMode = BundleSystem.SerializeMode.LibFunction;
  local serializeInfo = self:_SerializeTraverse(libFunc);

  --flatbuffer 序列化
  local serializer = Serializer();
  local encoder = serializer:GetEncoder();

  --整个场景应该只有一个根节点
  local cls = serializeInfo[1];
  if cls then
    --序列化版本号
    encoder:SetFieldInt("version",BundleSystem.Version);
    local childEncoder = encoder:GetChild();
    SerializationTool:_SerializeCls(cls,childEncoder);
    encoder:SetFieldClass("Data",childEncoder);
  end

  

  return serializer:GetBuffer();
  -- body
end

--从一个脚本node开始序列化
function BundleSystem:Serialize(root, serializeMode)
  BundleSystem.CurrentSerializeMode = serializeMode or BundleSystem.SerializeMode.Scene;
  local apollonode = root;
  local rootnode = root;
  
  if root.GetRootNode then
    rootnode = root:GetRootNode();
  end
  
  --开始序列化的通知
  self:SerializeStarted(rootnode);
  

  local serializeInfo = self:_SerializeTraverse(apollonode);


  --self:prtable(serializeInfo);

  --flatbuffer 序列化
  local serializer = Serializer();
  local encoder = serializer:GetEncoder();

  --整个场景应该只有一个根节点
  local cls = serializeInfo[1];
  if cls then
    --序列化版本号
    encoder:SetFieldInt("version",BundleSystem.Version);
    local childEncoder = encoder:GetChild();
    SerializationTool:_SerializeCls(cls,childEncoder);
    encoder:SetFieldClass("Data",childEncoder);
  end
  
  --完成序列化的通知
  self:SerializeFinished(rootnode);

  return serializer:GetBuffer();  --返回序列化结果
end

function BundleSystem:SerializeToMemoryTable(root)
  local apollonode = root;
  local rootnode = root;
  
  if root.GetRootNode then
    rootnode = root:GetRootNode();
  end
  
  --开始序列化的通知
  self:SerializeStarted(rootnode);
  

  local serializeInfo = self:_SerializeTraverse(apollonode);

  --self:prtable(serializeInfo);

  --flatbuffer 序列化
  local serializer = MSerializer();
  local encoder = serializer:GetEncoder();

  --整个场景应该只有一个根节点
  local cls = serializeInfo[1];
  if cls then
    --序列化版本号
    encoder:SetFieldInt("version",BundleSystem.Version);
    local childEncoder = encoder:GetChild();
    SerializationTool:_SerializeCls(cls,childEncoder);
    encoder:SetFieldClass("attributes",childEncoder);
    
    --根据flatbuffer的格式需要额外设置个typename
    local typename = childEncoder:GetMemberList()["typename"];
    encoder:SetFieldString("typename",typename);
  end
  
  --完成序列化的通知
  self:SerializeFinished(rootnode);

  return serializer:GetBuffer();  --返回序列化结果
end

--parma: withscene  提供scene来反序列化，内部就不再创建scene了,只是把文件中的Node都反序列化到当前scene下
function BundleSystem:DeserializeFromPath(path, deserializeMode, withscene, sceneTables)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}
  local scene = nil;
  
  local abPath = venuscore.IFileSystem:PathAssembly(path);
  

  local currTime =  venuscore.ITimerSystem:GetTimevalue();

  local pathMeatadata = apollocore.SceneLoaderPathMetadata(abPath);
  local sceneLoaderEntity = apollocore.SceneLoaderEntity();
  sceneLoaderEntity:PushMetadata(pathMeatadata);
  sceneLoaderEntity:CreateResource();
  
  local _sceneTable = sceneLoaderEntity:GetSceneTable();
  local version = _sceneTable[1].version;
  local typename = _sceneTable[1].typename;
  local attributes = _sceneTable[1].attributes;
  if sceneTables ~= nil then
    sceneTables[path] = _sceneTable;
  end

  local currTime1 =  venuscore.ITimerSystem:GetTimevalue();

  WARNING("usetime1 = " .. tostring(currTime1-currTime));
  if typename == "Scene" or typename == "Actor" then
    if version == 1 then
      if withscene == nil then
        scene = apollocore.SceneManager:CreateScene(EditorSceneName);
      else
        scene = withscene;
      end
    elseif version == 2 then
      scene = self:_DeSerializeSceneWithAttributes(nil,attributes,nil,nodes,referenceinfo,withscene);
    end
  else
    scene = withscene;
  end
  
  if scene == nil then
    ERROR("Error!!!!! Scene is nil");
    return nil,nil;
  end
  
  --跳过根节点反序列化场景Nodes(但是根节点的属性都会反序列化到当前场景根节点上）
  nodes = self:_DeserializeWithAttributes(version,attributes, scene, deserializeMode,true) 

  local currTime2 = venuscore.ITimerSystem:GetTimevalue();
  WARNING("currTime2 = " .. tostring(currTime2-currTime1));
  WARNING("usetimeAll = " .. tostring(currTime2-currTime));
 
  return scene, nodes;
end

function BundleSystem:DeserializeFromMemoryTable(memTable, deserializeMode,withscene)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}
  local scene = nil;
  
  local currTime =  venuscore.ITimerSystem:GetTimevalue();

  
  local _sceneTable = memTable;
  local version = _sceneTable[1].version;
  local typename = _sceneTable[1].typename;
  local attributes = _sceneTable[1].attributes;


  local currTime1 =  venuscore.ITimerSystem:GetTimevalue();

  WARNING("usetime1 = " .. tostring(currTime1-currTime));
  if typename == "Scene" or typename == "Actor" then
    if version == 1 then
      if withscene == nil then
        scene = apollocore.SceneManager:CreateScene(EditorSceneName);
      else
        scene = withscene;
      end
    elseif version == 2 then
      scene = self:_DeSerializeSceneWithAttributes(nil,attributes,nil,nodes,referenceinfo,withscene);
    end
  else
    scene = withscene;
  end
  
  if scene == nil then
    ERROR("Error!!!!! Scene is nil");
    return nil,nil;
  end
  
  --跳过根节点反序列化场景Nodes(但是根节点的属性都会反序列化到当前场景根节点上）
  nodes = self:_DeserializeWithAttributes(version,attributes, scene, deserializeMode,true) 

  local currTime2 = venuscore.ITimerSystem:GetTimevalue();
  WARNING("currTime2 = " .. tostring(currTime2-currTime1));
  WARNING("usetimeAll = " .. tostring(currTime2-currTime));
 
  return scene, nodes;
end


--从一个内存Table中反序列化
--clone_behavior脚本中用到了这个接口(用来在运行期克隆节点)
function BundleSystem:DeserializeFromMemoryTable(memoryTable, deserializeMode, withscene)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}
  local scene = nil;
  

  local _sceneTable = memoryTable;
  local version = _sceneTable[1].version;
  local typename = _sceneTable[1].typename;
  local attributes = _sceneTable[1].attributes;


  if typename == "Scene" or typename == "Actor" then
    if version == 1 then
      if withscene == nil then
        scene = apollocore.SceneManager:CreateScene(EditorSceneName);
      else
        scene = withscene;
      end
    elseif version == 2 then
      scene = self:_DeSerializeSceneWithAttributes(nil,attributes,nil,nodes,referenceinfo,withscene);
    end
  else
    scene = withscene;
  end
  
  if scene == nil then
    ERROR("Error!!!!! Scene is nil");
    return nil,nil;
  end
  
  --跳过根节点反序列化场景Nodes(但是根节点的属性都会反序列化到当前场景根节点上）
  nodes = self:_DeserializeWithAttributes(version,attributes, scene, deserializeMode,true) 
 
  return scene, nodes;
end


function BundleSystem:DeserializeScene(path, deserializeMode,withscene)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}
  local scene = nil;
  

  local pathMeatadata = apollocore.SceneLoaderPathMetadata(path);
  local sceneLoaderEntity = apollocore.SceneLoaderEntity();
  sceneLoaderEntity:PushMetadata(pathMeatadata);
  sceneLoaderEntity:CreateResource();
  
  local _sceneTable = sceneLoaderEntity:GetSceneTable();
  local version = _sceneTable[1].version;
  local typename = _sceneTable[1].typename;
  local attributes = _sceneTable[1].attributes;
  
  if typename == "Scene" or typename == "Actor" then
    if version == 1 then
      scene = apollocore.SceneManager:CreateScene(EditorSceneName);
    elseif version == 2 then
      scene = self:_DeSerializeSceneWithAttributes(nil,attributes,nil,nodes,referenceinfo,withscene);
    end
  end
  return scene;
end


function BundleSystem:DeSerializeLibFunction(libFunctionPath, scene, hostNode)

  local file = io.open(libFunctionPath, "rb");
  local str = file:read("*a");
  local serializer = Serializer();
  local decoder = serializer:GetDecoderFromBuffer(str);
  local referenceinfo = {};
  referenceinfo.nodemap = {};
  referenceinfo.callbacks = {};
  --DeSerialize
    --self:_DeSerializeVer2(decoder, {node}, referenceinfo);
  return self:_DeSerializeCls(decoder, scene, {hostNode}, referenceinfo);
  -- body
end


--反序列化Nodes，需要传入scene
function BundleSystem:DeSerializeNodes(path, scene, deserializeMode)

  BundleSystem.CurrentDeserializeMode = deserializeMode or BundleSystem.DeserializeMode.Prefab;
  BundleSystem.CurrentScene = scene;
  BundleSystem.SkipRootNodeForScene = true;
  local nodes = {};
  local referenceinfo = {};
  referenceinfo.nodemap = {};
  referenceinfo.callbacks = {};
  BundleSystem.PrefabChangeIDMap = {};
 

  if deserializeMode == BundleSystem.DeserializeMode.Scene then
    referenceinfo = apollocore.SceneManager:GetReference(scene:GetStaticID()) or referenceinfo;
  end
  

  local pathMeatadata = apollocore.SceneLoaderPathMetadata(path);
  local sceneLoaderEntity = apollocore.SceneLoaderEntity();
  sceneLoaderEntity:PushMetadata(pathMeatadata);
  sceneLoaderEntity:CreateResource();
  
  local _sceneTable = sceneLoaderEntity:GetSceneTable();
  local version = _sceneTable[1].version;
  local typename = _sceneTable[1].typename;
  local attributes = _sceneTable[1].attributes;
  
  return self:_DeserializeWithAttributes(version,attributes, scene, deserializeMode,true) 
end

--内部使用
--用已经反序列化出来的Attributes来反序列化
function BundleSystem:_DeserializeWithAttributes(version,attributes,scene,deserializeMode, skipRootNodeForScene)
  BundleSystem.CurrentDeserializeMode = deserializeMode or BundleSystem.DeserializeMode.Prefab;
  BundleSystem.CurrentScene = scene;
  BundleSystem.SkipRootNodeForScene = skipRootNodeForScene or false;
  local nodes = {};
  local referenceinfo = {};
  referenceinfo.nodemap = {};
  referenceinfo.callbacks = {};

  if deserializeMode == BundleSystem.DeserializeMode.Scene then
    referenceinfo = apollocore.SceneManager:GetReference(scene:GetStaticID()) or referenceinfo;
  end


  if version == 1 then
    self:_DeSerializeVer1WithAttributes(attributes, nodes, referenceinfo);
  else
    self:_DeSerializeVer2WithAttributes(attributes, nodes, referenceinfo);
  end


  for i, v in ipairs(referenceinfo.callbacks) do
    local obj = referenceinfo.nodemap[v.key];
    if obj then
      v.func(obj);
    else
      ERROR("unkown reference object id: "..v.key);
    end
  end


  for i = 1, #nodes do
    if nodes[i].OnDeserializeFinished then
      nodes[i]:OnDeserializeFinished();
    end
  end

  -- Note: nodes not include rootNode
  if deserializeMode == BundleSystem.DeserializeMode.Scene then
    local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
    apolloRootNode:OnDeserializeFinished();
  end


  if not _KRATOSEDITOR then

    --非编辑器下,反序列的是场景时候 自动编译
    local orderList = nodes -- nodes {child to parent}
    local blueList = {}
    if self:_DoCompileWork(orderList, blueList) then
      local rootNode = scene:GetRootNode()
      local comp = rootNode:GetComponent(apollocore.Node.CT_BLUEPRINT)
      local compileFlag = true
      local blueprintScene = nil
      if comp ~= nil then
        blueprintScene = comp.Instances[BD.ScenePath]
        if blueprintScene ~= nil then
          local result = blueprintScene:CompileCode()
          if not result then
            compileFlag = false
          end
        end
      end

      if compileFlag then
        self:_DoBlueRunWork(blueList)
        if blueprintScene then blueprintScene:Run(); end
      end

    else
      ERROR("---blue compile fail---");
    end

  else
    -- 为下个场景加载而清理ClassDeclareMap
  end

  return nodes;
end

function BundleSystem:_DeSerializeVer1WithAttributes(attributes,nodes,referenceinfo)
  --判断是不是从C++根节点开始序列化的，如果是排除此节点
  --C++内置的根节点不做反序列化
  local typename = attributes["__typename"];
  if typename == "Actor" then
    for attKey,attValue in pairs(attributes) do
      if string.find(attKey,"ChildNodes")  then
        self:_DeSerializeClsWithAttributes(attKey,attValue,nil,nodes, referenceinfo);
      elseif attKey == "Name" then
        local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
        apolloRootNode:SetName(attValue);
      end
    end
  else
    self:_DeSerializeClsWithAttributes(attributes,BundleSystem.CurrentScene,nodes, referenceinfo);
  end
end


function BundleSystem:_DeSerializeVer2WithAttributes(attributes, nodes, referenceinfo)
  local typename = attributes["__typename"];
  if typename == "Scene" then
    for attKey, attValue in pairs(attributes) do
      if string.find(attKey,'RootNode') then      --Scene的RootNode属性特殊处理
                                                  --(RootNode不反序列化，直接把文件中的RootNode上的属性反序列化到当前RootNode上)
        if BundleSystem.SkipRootNodeForScene then
          self:_DeSerializeRootNodeWithAttributes(attValue,nodes,referenceinfo);
        else
          self:_DeSerializeClsWithAttributes(attKey,attValue,BundleSystem.CurrentScene,nodes,referenceinfo);
        end
      end
    end
  else
     self:_DeSerializeClsWithAttributes(nil,attributes,BundleSystem.CurrentScene,nodes, referenceinfo);
  end
end

--Scene的RootNode属性特殊处理
--RootNode不反序列化，直接把文件中的RootNode上的属性反序列化到当前RootNode上
function BundleSystem:_DeSerializeRootNodeWithAttributes(attributes,nodes,referenceinfo)
  local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
  
  for rootKey,rootValue in pairs(attributes) do
    if string.find(rootKey,'ChildNodes') then
      self:_DeSerializeClsWithAttributes(rootKey,rootValue,BundleSystem.CurrentScene,nodes, referenceinfo);
    elseif rootKey == "Name" then
      apolloRootNode:SetName(rootValue);
    elseif rootKey == "Components" then
      self:_DeSerializeClsWithAttributes(rootKey,rootValue, apolloRootNode, nodes, referenceinfo);
    elseif rootKey == "Layer" then
      apolloRootNode.Layer = venuscore.Utility:ConvertStringToUInt64(rootValue);
    end
  end
end

-- 反序列化完成 并且Awake完成之后 对蓝图进行编译(索引->引用 rtti检查 变量/node/component引用检查等)
-- 对于整个场景有多个蓝图: 先子后父,兄弟无顺序  CompileCode +  Run(目前两个场景都会Run)
function BundleSystem:_DoCompileWork(orderList, blueList)

  local compileResult = true
  if orderList == nil  or next(orderList) == nil then
    return compileResult
  end

  for _, node in pairs(orderList) do
    if type(node) ~= 'table' then
      --LOG("blue check node"..tostring(node))
      if node:HaveComponent(apollocore.Node.CT_BLUEPRINT) then
        --LOG("[_DoCompileWork] node "..tostring(node.Name) ) -- for debug
        local comp = node:GetComponent(apollocore.Node.CT_BLUEPRINT)
        local blueprint = comp.Instances[BD.LuaPath]
        if blueprint ~= nil then
          if blueprint:CompileCode() then
            table.insert(blueList, blueprint)
          else
            ERROR("[_DoCompileWork] node "..tostring(node.Name).." bluecomp compile fail")
            compileResult = false
          end
        else
          WARNING("[_DoCompileWork] node "..tostring(node.Name).." bluecomp do NOT contain blueprint")
        end
      end
    end
  end
  return compileResult
end


function BundleSystem:_DoBlueRunWork(orderList)
  for _, blueprint in ipairs(orderList) do -- array
    blueprint:Run();
  end
end



function BundleSystem:SerializeStarted(apolloNode)
  if apolloNode then
    if apolloNode.OnSerializeStarted ~= nil then
      apolloNode:OnSerializeStarted();
    end
    
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeStarted(childNode);
    end
  end
end

function BundleSystem:SerializeFinished(apolloNode)
  if apolloNode then
    if apolloNode._Script then
      apolloNode._Script:OnSerializeFinished();
    end
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeFinished(childNode);
    end
  end
end

--遍历C++场景，构建序列化信息
function BundleSystem:_SerializeTraverse(apollonode,pathHandler)
  local info = {}
  if apollonode then
    self:_SerializeTraverseNode(apollonode,nil,nil,info,pathHandler); --序列化无脚本的C++node
  end

  --[[  暂时屏蔽prefab功能，等prefab分支上线后再开启
  if apollonode._Script and apollonode._Script:GetPrefabPath() then
    local prefabPath = apollonode._Script:GetPrefabPath();
    local newInfo = {};
    newInfo[1] = PrefabTool:GenerateSerializationInfo(prefabPath, info[1]);
    return newInfo;
  elseif apollonode.GetPrefabPath and apollonode:GetPrefabPath() ~= "" then
    local prefabPath = apollonode:GetPrefabPath();
    local newInfo = {};
    newInfo[1] = PrefabTool:GenerateSerializationInfo(prefabPath, info[1]);
    return newInfo;
  end
  ]]--
  return info;
end



--为了兼容反序列化: 反序列化scene和不反序列化scene两种情况
function BundleSystem:_DeSerializeSceneWithAttributes(key,attributes,host,nodes,referenceinfo,existscene)
  local typename = attributes["__typename"];
  local cls = nil;
  local func = BundleSystem:GetDeserializationCallback(typename);
  cls = func(attributes,host, cls, key, nodes, referenceinfo, existscene);
  return cls;
end

--内部使用
function BundleSystem:_DeSerializeClsWithAttributes(key,attributes,host,nodes,referenceinfo)
  local typename = attributes["__typename"];
  local cls = nil;
  local func = BundleSystem:GetDeserializationCallback(typename);
  cls = func(attributes,host, cls, key, nodes, referenceinfo, nil);
  return cls;
end

--遍历单个Node构建序列化信息
function BundleSystem:_SerializeTraverseNode(obj,root,rootkey,info,pathHandler)
  
  if pathHandler then
    rootkey = pathHandler(type(rootkey),rootkey);
  end
    
  local isRef = venuscore.isReference(root, rootkey);
  if isRef then--引用类型，不在进行递归 
    local cls = {};
    cls["members"] = {};
    cls["fieldname"] = rootkey;
    if venuscore.isNil(obj) then
      return
    end
    if type(obj) == "userdata" then
      cls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
      cls["value"] = obj:GetStaticID();
    elseif type(obj) == "table" then--table
      if obj.GetTypeName then
        cls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
        cls["value"] = obj:GetStaticID();
      else
        cls["typename"] = "table";
        for k, v in pairs(obj) do
          local childCls = {};
          childCls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
          childCls["value"] = v:GetStaticID();
          --childCls["fieldname"] = k;
          childCls["members"] = {};
          --table.insert(cls["members"], childCls);
          cls["members"][k] = childCls;
        end
      end
    elseif type(obj) == "number" then -- scene的属性
      cls["typename"] = "number";
      cls["value"] = obj;
    end
    --table.insert(info,cls);
    if rootkey == nil then
      table.insert(info,cls)
    else
      info[rootkey] = cls;
    end
  else
    local t = type(obj);
    if t == "userdata" then
      local tm = getmetatable(obj);
      local str = obj:GetTypeName();
      
      if pathHandler then
        obj = pathHandler(str,obj);
      end
      local cls = {};
      if BundleSystem.RegisterSerializationDelegates[str] then
        local func = BundleSystem.RegisterSerializationDelegates[str];
        cls = func(obj, rootkey);
        table.insert(info,cls);
      else
        cls["typename"] = str;
        cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
        --cls["fieldname"] = rootkey or "";
        cls["members"] = cls["members"] or {};
        --table.insert(info,cls);
        for key, handle in MemberIterator(obj) do
          self:_SerializeTraverseNode(obj[key],obj,key,cls["members"],pathHandler);
        end
        --如果是prefab则只记录差异和原始prefab文件
        if _KRATOSEDITOR and BundleSystem.SerializeByPrefab then
          if false then
            if obj._Script and obj._Script:GetPrefabPath() then
              local prefabPath = obj._Script:GetPrefabPath();
              local newInfo = {};
              newInfo = PrefabTool:GenerateSerializationInfo(prefabPath, cls);
              cls = newInfo;
            elseif obj.PrefabPath ~= nil and obj.PrefabPath ~= "" then
              local newInfo = {};
              newInfo = PrefabTool:GenerateSerializationInfo(obj.PrefabPath, cls);
              cls = newInfo;
            end
          end
        end
        --table.insert(info,cls);
        if rootkey == nil then
          table.insert(info,cls)
        else
          info[rootkey] = cls;
        end
      end
    elseif t == "table" then  --脚本序列化
      local str = "";
      local cls = {};
      if obj.GetTypeName then  --脚本node对象
        str = obj:GetTypeName();
      else   --普通table
        str = "table";
      end
      cls["typename"] = str;
      cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
      --cls["fieldname"] = rootkey or "";
      cls["members"] = cls["members"] or {};
      --table.insert(info,cls);
      if rootkey == nil then
        table.insert(info,cls)
      else
        info[rootkey] = cls;
      end
      if obj.GetTypeName then  --从venuscore派生的对象是有注册信息的
        for key, handle in MemberIterator(obj) do
          if obj:isTypeOrDriverType(libvenuscore.Object) and obj:GetScriptValue(key) ~= nil then
          --if obj:is(libvenuscore.VenusBehavior) and obj:GetScriptValue(key) ~= nil then
            info[key] = self:_SerializeTraverseNode(obj:GetScriptValue(key), obj, key,cls["members"],pathHandler);
          else
            if obj[key] ~= nil then
              info[key] = self:_SerializeTraverseNode(obj[key], obj, key,cls["members"],pathHandler);
            end  
          end
        end
      else --普通lua table是没有注册信息的
        for key, handle in pairs(obj) do
          --用来处理遍历ChildNodes时候的Layer过滤
          local childObj = obj[key];
          if type(childObj) == "userdata" and childObj.isTypeOrDriverType and childObj:isTypeOrDriverType(apollocore.Node:RTTI()) then
            if not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_SCENE_LAYER)
              and not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_UI_LAYER) 
              and not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_CLOTHDEBUG_LAYER) then
                childObj:CheckOriginID();
                self:_SerializeTraverseNode(childObj,obj,childObj.Name,cls["members"],pathHandler);
            end
          else
            self:_SerializeTraverseNode(childObj,obj,key,cls["members"],pathHandler);
          end
        end
      end
    elseif t == "number" or t == "boolean" or t == "string" then
      if pathHandler then
        obj = pathHandler(t,obj);
      end
      local cls = {};
      cls["typename"] = t;
      --cls["fieldname"] = rootkey;
      --cls["members"] = {};
      cls["value"] = obj;
      --table.insert(info,cls);
      if rootkey == nil then
        table.insert(info,cls)
      else
        info[rootkey] = cls;
      end
    elseif BundleSystem.SerializeDelegates[rootkey] then
      local func = BundleSystem.SerializeDelegates[rootkey];
      local typename,fieldname = func(obj);
      local cls = {};
      cls["typename"] = typename;
      --cls["fieldname"] = rootkey;
      cls["members"] = {};
      cls["value"] = fieldname;
      --table.insert(info,cls);
      if rootkey == nil then
        table.insert(info,cls)
      else
        info[rootkey] = cls;
      end
    end
  end
end


--专门给编辑器内部使用的反序列化方法
--蓝图重置场景的时候需要从一个buffer反序列化场景
--C++的反序列化方案目前不能传buffer
if _KRATOSEDITOR then

    function BundleSystem:SerializeGiftScene(root,handler)
    
    local apollonode = root;
    local rootnode = root;
    
    if root.GetRootNode then
      rootnode = root:GetRootNode();
    end
    
    --开始序列化的通知
    self:SerializeStarted(rootnode);
    

    local serializeInfo = self:_SerializeTraverse(apollonode,handler);

    --self:prtable(serializeInfo);

    --flatbuffer 序列化
    local serializer = Serializer();
    local encoder = serializer:GetEncoder();

    --整个场景应该只有一个根节点
    local cls = serializeInfo[1];
    if cls then
      --序列化版本号
      encoder:SetFieldInt("version",BundleSystem.Version);
      local childEncoder = encoder:GetChild();
      SerializationTool:_SerializeCls(cls,childEncoder);
      encoder:SetFieldClass("Data",childEncoder);
    end
    
    --完成序列化的通知
    self:SerializeFinished(rootnode);

    return serializer:GetBuffer();  --返回序列化结果
  end

  function BundleSystem:DeserializeSceneFromMemory(bufferStr, deserializeMode, existscene)
    local nodes = {};
    local referenceinfo = {}
    referenceinfo.nodemap = {}
    referenceinfo.callbacks = {}
    local scene = nil;
    local serializer = Serializer();
    local decoder = serializer:GetDecoderFromBuffer(bufferStr);
    local typename = decoder:AsString(1);
    if typename == "Scene" or typename == "Actor" then
      if serializer.version == 1 then
        scene = apollocore.SceneManager:CreateScene(EditorSceneName);
      elseif serializer.version == 2 then
        scene = self:_DeSerializeCls(decoder, nil, nodes, referenceinfo, existscene);
      end
    end
    return scene;
  end
  
  function BundleSystem:DeSerialize(bufferAsString, scene, deserializeMode, skipRootNodeForScene)
    BundleSystem.CurrentDeserializeMode = deserializeMode or BundleSystem.DeserializeMode.Prefab;
    BundleSystem.CurrentScene = scene;
    BundleSystem.SkipRootNodeForScene = skipRootNodeForScene or true;
    local nodes = {};
    local referenceinfo = {};
    referenceinfo.nodemap = {};
    referenceinfo.callbacks = {};
   
    if deserializeMode == BundleSystem.DeserializeMode.Scene then
      referenceinfo = apollocore.SceneManager:GetReference(scene:GetStaticID()) or referenceinfo;
    end
    

    local serializer = Serializer();
    local decoder = serializer:GetDecoderFromBuffer(bufferAsString);
    
    if serializer.version == 1 then
      self:_DeSerializeVer1(decoder, nodes, referenceinfo);
    else
      self:_DeSerializeVer2(decoder, nodes, referenceinfo);
    end
    
    for i, v in ipairs(referenceinfo.callbacks) do
      local obj = referenceinfo.nodemap[v.key];
      if obj then
        v.func(obj);
      else
        ERROR("unkown reference object id: "..v.key);
      end
    end

    for i = 1, #nodes do
      if nodes[i].OnDeserializeFinished then
        nodes[i]:OnDeserializeFinished();
      end
    end

    -- Note: nodes not include rootNode
    if deserializeMode == BundleSystem.DeserializeMode.Scene then
      local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
      apolloRootNode:OnDeserializeFinished();
    end

    return nodes;
  end
  
  --decoder: 解码器
  --thisCls: 是否需要创建该类型（如果父类中已经生成了此对象则此值非空)
  --nodes: 返回值，创建的脚本node都放入此列表中
  --host: 当前对象thisCls的父对象（C++对象）
  --existscene  如果当前反序列化场景本身属性  场景本身存在则不需要创建场景(existscene为空的game场景 maincamera属性需要加入referenceinfo刷引用)
  function BundleSystem:_DeSerializeCls(decoder, host, nodes, referenceinfo, existscene)
    local typename = decoder:AsString(1);
    local cls = nil;
    local func = BundleSystem:GetDeserializationCallback(typename);
    local attributes,times = SerializationTool:GetAttribute(decoder);
    cls = func(attributes, host, cls, nil, nodes, referenceinfo, existscene);
    return cls;
  end
  
  function BundleSystem:_DeSerializeVer1(decoder, nodes, referenceinfo)
    --判断是不是从C++根节点开始序列化的，如果是排除此节点
    --C++内置的根节点不做反序列化
    local typename = decoder:AsString(1);
    if typename == "Actor" then
      local memberListCnt = decoder:GetLength();
      for i = 2, memberListCnt do
        local fieldName = decoder:GetFieldName(i);
        if string.find(fieldName,'ChildNodes') then
          local childDecoder = decoder:AsClass(i);
          self:_DeSerializeCls(childDecoder,nil,nodes, referenceinfo);
        elseif fieldName == "Name" then
          local rootname = decoder:AsString(i);
          local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
          apolloRootNode:SetName(rootname);
        end
      end
    else
      self:_DeSerializeCls(decoder,BundleSystem.CurrentScene,nodes, referenceinfo);
    end
  end
  
  function BundleSystem:_DeSerializeVer2(decoder, nodes, referenceinfo)
    local typename = decoder:AsString(1);
    if typename == "Scene" then
      local memberListCnt = decoder:GetLength();
      for i = 2, memberListCnt do
        local fieldName = decoder:GetFieldName(i);
        if string.find(fieldName,'RootNode') then
          local childDecoder = decoder:AsClass(i);
          if BundleSystem.SkipRootNodeForScene then
            local memberListCnt = childDecoder:GetLength();
            for j = 2, memberListCnt do
              local fieldName = childDecoder:GetFieldName(j);
              if string.find(fieldName,'ChildNodes') then
                self:_DeSerializeCls(childDecoder:AsClass(j),BundleSystem.CurrentScene,nodes, referenceinfo);
              elseif fieldName == "Name" then
                local rootname = childDecoder:AsString(j);
                local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
                apolloRootNode:SetName(rootname);
              elseif fieldName == "Components" then
                local fieldType = childDecoder:GetFieldType(j)
                local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
                self:_DeSerializeCls(childDecoder:AsClass(j), apolloRootNode, nodes, referenceinfo);
              end
            end
          else
            self:_DeSerializeCls(childDecoder,BundleSystem.CurrentScene,nodes,referenceinfo);
          end
        end
      end
    else
      self:_DeSerializeCls(decoder,BundleSystem.CurrentScene,nodes, referenceinfo);
    end
  end
end


return BundleSystem;