local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local TwoMirror = {}
TwoMirror.material = nil;
TwoMirror.renderobject = nil;
TwoMirror.Queue = 116;

function TwoMirror:Initialize(host, size)
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/twomirror.material");
  return self.Queue;
end

function TwoMirror:Resizeview(size)
end

function TwoMirror:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return TwoMirror;

