local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local RadialBlur = {}
RadialBlur.renderobject = nil;
RadialBlur.material = nil;
RadialBlur.Queue = 123;

function RadialBlur:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.SPACE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SPACE");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/radialblur.material" );
  self.material:SetParameter(self.SPACE, mathfunction.vector1(0.015));  --0.001~0.025 0.001步伐调试 
  return self.Queue;
end

function RadialBlur:Resizeview(size)
  --self:_SetParam(size);
end

function RadialBlur:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return RadialBlur;