local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local contrastfilter = {}
contrastfilter.CfMat = 0;
contrastfilter.Queue = 111;



function contrastfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.CONTRAST = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CONTRAST");  
  self.CfMat = host:CreateMaterial("comm:documents/filter/material/contrastfilter.material" );
  self.CfRO = host:CreateRenderObject()
  self.CfMat:SetParameter(self.CONTRAST, mathfunction.vector1(0.5));
  --self:_SetParam(size);
  return self.Queue;
end

function contrastfilter:Resizeview(size)
  --self:_SetParam(size);
end

function contrastfilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.CfMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.CfRO, self.CfMat);
  context:EndRenderPass();
end

return contrastfilter;