local Types = require "venuscore.rtti.types"
local libvenuscore = require "libvenuscore"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueDynamicNode = require "bluecore.base.blue_dynamic_node"
local BlueScriptCompInsRef = BlueDynamicNode:extend();

BlueScriptCompInsRef:MemberRegister("comp", Types.ReferenceType(AE.ScriptComponent:RTTI()));
BlueScriptCompInsRef:MemberRegister("compName");
BlueScriptCompInsRef:MemberRegister("ins");


function BlueScriptCompInsRef:new(graph, comp, ins)

  BlueScriptCompInsRef.super.new(self, graph)

  self.comp = comp 
  self.ins = ins
  self.compName = nil

end

function BlueScriptCompInsRef:_OnDuplicate()

  local luaPath = self[BD.LUA_CLASS_PATH];
  local clazz = require(luaPath);
  local bluePrintNode = clazz(self.graph, self.comp, self.ins); --创造实例
  bluePrintNode[BD.LUA_CLASS_PATH] = luaPath;
  bluePrintNode:EditorCreate();
  return bluePrintNode;

end

function BlueScriptCompInsRef:_OnCompile()
  if libvenuscore.isNil(self.comp) or self.comp.Instances[self.ins] == nil then
    self.compileResult = "component is lost";
    return false
  end
  return true
end

function BlueScriptCompInsRef:GetRef()
  return self.comp;
end

function BlueScriptCompInsRef:GetNewArgs()
  return {self.comp, self.ins};
end

if _KRATOSEDITOR then

  function BlueScriptCompInsRef:_OnCreateWithEditor()

    BlueScriptCompInsRef.super._OnCreateWithEditor(self);
    assert(self.comp, "[BlueScriptCompInsRef] comp is nil")

    self.compName = self.ins.."\n"..self.comp:GetTypeName().."\n".."node: ".. self.comp:GetHostNode():GetName();
    self[BD.OUTPUTS_INFO][1].name = self.compName
    self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
    LOG("[BlueScriptCompInsRef] compName "..tostring(self.compName))

  end


  --编辑的时候如果node名字改变了也做修改
  --FIXME(hjh) 这里会有点别扭  名字不会同步到game里头 但是stop下来scene反序列化一份就是一样的了
  function BlueScriptCompInsRef:_OnUpdateByEditor()
    BlueScriptCompInsRef.super._OnUpdateByEditor(self);
    if self:_OnCompile() then
      self.compName = self.ins.."\n"..self.comp:GetTypeName().."\n".."node: ".. self.comp:GetHostNode():GetName();
      self[BD.OUTPUTS_INFO][1].name = self.compName
      self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
    --else
    --  self.compileResult = "component is lost";
    end
  end

end

function BlueScriptCompInsRef:_OnDeserializePost()
  BlueScriptCompInsRef.super._OnDeserializePost(self)
  --兼容老素材
  self.ins = string.gsub(self.ins, '//', '/');
  if _KRATOSEDITOR then
    self[BD.OUTPUTS_INFO][1].name = self.compName
    self[BD.OUTPUTS_INFO][1].tips = "Instance Reference of "..self.compName
  end
end

function BlueScriptCompInsRef:GetOutputByIndex(index)
  return self.comp.Instances[self.ins]
end


BlueScriptCompInsRef:RegisterOutput(1, Types.ScriptInsRefType, "instance", "instance of script component");
BlueScriptCompInsRef:SetFunctionType(BD.COMPONENT_CONTENT_NODE);
BlueScriptCompInsRef:SetFunctionName(BD.COMPONENT_CONTENT.SCRIPT_INS);

return BlueScriptCompInsRef