local BD = require "bluecore.bluedefined"
local TN = require "bluecore.base.transaction_node"
local Types = require "venuscore.rtti.types"
local GetBirthDay = TN:extend();

function GetBirthDay:new(...)
  GetBirthDay.super.new(self, ...)
end

local function parseDate(str)
  if str == nil then return nil end
  local y, m, d = str:match("(%d+)-(%d+)-(%d+)")
  if y == nil then
    return nil
  end
  if m == '' then
    m = 1
  end
  if d == '' then
    d = 1
  end
  WARNING("yyyy:"..tostring(y)..",mm:"..tostring(m)..",dd:"..tostring(d));
  return tonumber(y), tonumber(m), tonumber(d) -- if no number, result is nil
end

function GetBirthDay:_OnJsonToResult(jsonTbl)
  return parseDate(jsonTbl["birthday"]),jsonTbl["birthday"]
end

-- override
function GetBirthDay:_OnCheckReady(outputResults)
  local result = outputResults ~= nil and outputResults[1] ~= nil and type(outputResults[1]) == 'number'
  if not result then -- just check first result type
    WARNING("[GetBirthDay] _OnCheckReady not ready "..tostring(outputResults));
  end
  return result
end

-- override
function GetBirthDay:_OnRequestJson()
  return "{}" -- do need extra info
end

-- override
function GetBirthDay:_OnRequestType()
  return BD.RequestType.BIRTH_DAY
end

-- add
GetBirthDay:RegisterOutput(1, Types.IntType, "year",  "year")
GetBirthDay:RegisterOutput(2, Types.IntType, "month", "month")
GetBirthDay:RegisterOutput(3, Types.IntType, "day",   "day")
GetBirthDay:RegisterOutput(4, Types.StringType, "string", "yyyy-mm-dd")

GetBirthDay:SetFunctionName("Get BirthDay");

return GetBirthDay;

