local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Atan = BlueNode:extend();

---- 游戏运行模式
function Atan:new(...)
  Atan.super.new(self, ...)
end

function Atan:_OnUpdate(args)
  
  local res = math.atan(args[1]);
  return res, res*180.0/math.pi;

end

---- 编辑器模式

Atan:RegisterInput(1, Types.FloatType, "val", "[1]", 0);
Atan:RegisterOutput(1, Types.FloatType, "rad", "反正切结果(弧度)");
Atan:RegisterOutput(2, Types.FloatType, "angle", "反正切结果(角度)");
Atan:SetFunctionName("Atan");
Atan:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Atan;

