local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local RandomFloatRange = BlueNode:extend();

---- 游戏运行模式
function RandomFloatRange:new(...)
  RandomFloatRange.super.new(self, ...)
end

function RandomFloatRange:_OnUpdate(args)
  return args[1] + (math.random() * (args[2] - args[1]));
end

---- 编辑器模式
RandomFloatRange:RegisterInput(1, Types.FloatType, "min", "最小(含)", 0)
RandomFloatRange:RegisterInput(2, Types.FloatType, "max", "最大(不含)", 1)
RandomFloatRange:RegisterOutput(1, Types.FloatType, "Random Float", "返回随机数");

RandomFloatRange:SetFunctionName("Random Float With Range")
RandomFloatRange:SetFunctionType(BD.STATIC_FUNCTION_NODE)

return RandomFloatRange;