local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local mathfunction = require "mathfunction"

local Equal = BlueNode:extend();

---- 游戏运行模式
function Equal:new(...)
  Equal.super.new(self, ...)
  self.result = false ;
end

function Equal:_OnUpdate(args)
  if args[1] ==  args[2] then
    self.result = true
  else
    self.result = false
  end 
  return self.result;
end

---- 编辑器模式
Equal:RegisterInput(1, mathfunction.vector3():RTTI(), "1", "[1]", mathfunction.vector3(0.0,0.0,0.0));
Equal:RegisterInput(2, mathfunction.vector3():RTTI(), "2", "[2]", mathfunction.vector3(0.0,0.0,0.0));

Equal:RegisterOutput(1, Types.BoolType, "==", "对比结果");

Equal:SetFunctionName("==");
Equal:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Equal ;

