


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"
local SetParameterNode = require "bluecore.setparameternode"

local SetVector2Value = SetParameterNode:extend();
--Unreal Engine: Set Vector Parameter Value 
--UE uses color去匹配vec2 vec3 vec4 这里单独拆开

---- 游戏运行模式
function SetVector2Value:new(...)
  SetVector2Value.super.new(self, ...)
end

function SetVector2Value:_OnUpdate(args)

  local paraType = self:GetParameterType(args);
  self:SetParameter(args, paraType, apolloengine.MaterialEntity.VT_VEC2);

end



---- 编辑器模式


SetVector2Value:RegisterInput(1, apolloengine.MaterialEntity:RTTI(), "Material", "材质实体", BlueSelf());
SetVector2Value:RegisterInput(2, Types.StringType, "ParaName", "参数名字", "None");
SetVector2Value:RegisterInput(3, mathfunction.vector2:RTTI(), "ParaValue", "参数值", mathfunction.vector2(1.0,1.0));



SetVector2Value:RegisterExecInput(1, "exec", "执行");

SetVector2Value:RegisterExecOutput(1, "exec", "执行");

SetVector2Value:SetFunctionName("SetVector2Value");


return SetVector2Value ;

