local AE = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local RttiOfME = AE.MaterialEntity:RTTI();
local SetMat = BlueNode:extend();
local BlueRtti = require "bluecore.core.blue_rtti"
--Unreal Engine: Set Material 

--这里的材质输入引脚字面值为默认的材质路径字符串  连线则为MaterialEntity 运行时根据输入值类型判断

---- 游戏运行模式
function SetMat:new(...)
	SetMat.super.new(self, ...)
end

function SetMat:_OnUpdate(args)

	local node = args[1];
	local index = args[2];
	local mat = args[3];
	local material = mat;
	if type(mat) == "string" then
		material = BlueRtti.Create(RttiOfME, mat)
	end

	local render = node:GetComponent(AE.Node.CT_RENDER)
	if _KRATOSEDITOR then
		if not render then
  		self.errorWarning = "can not find RenderComponent";
  		return;
		elseif not render.MaterialEntities then
			self.errorWarning = "Nil MaterialEntity";
			return;
		elseif  #render.MaterialEntities + 1 < index then --替换 新增
			self.errorWarning = "Error Materialentity Index"; 
			return;
		--如果引脚没有连接，应该是个字面值是个NoneType，会生成叶节点BlueNoneNode 会返回nil
		elseif not material  then --连线输入材质为空
			self.errorWarning = "Nil Input Materialentity";
			return;
		end
	end

	render:ChangeMaterial(material, index); 

end

---- 编辑器模式


SetMat:RegisterInput(1, AE.Node:RTTI(), "target", "target指向场景中的node", BlueSelf());
SetMat:RegisterInput(2, Types.IntType, "Element Index", "索引", 1);
SetMat:RegisterInput(3, RttiOfME, "Mat", "输入材质实例", "comm:documents/material/unlit.mat");

SetMat:RegisterExecInput(1, "exec", "执行");

SetMat:RegisterExecOutput(1, "exec", "执行");

SetMat:SetFunctionName("SetMat");


return SetMat ;

