


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"



local Types = require "venuscore.rtti.types"




local GetMat = BlueNode:extend();
--Unreal Engine: Get Material 


---- 游戏运行模式
function GetMat:new(...)
  GetMat.super.new(self, ...)
end



function GetMat:_OnUpdate(args)

  local render = args[1]:GetComponent(apolloengine.Node.CT_RENDER)
  if not render then
  	self.errorWarning = "can not find RenderComponent";
  	return;
  end
  if not render.MaterialEntities[args[2]] then
  	self.errorWarning = "nil MaterialEntity";
  	return;
  end
  return render.MaterialEntities[args[2]];

end


---- 编辑器模式

GetMat:RegisterInput(1, apolloengine.Node:RTTI(), "target", "target指向场景中的node", BlueSelf());
GetMat:RegisterInput(2, Types.IntType, "Element Index", "索引", 1);

GetMat:RegisterOutput(1, apolloengine.MaterialEntity:RTTI(), "Return Mat", "返回的材质实例");

GetMat:RegisterExecInput(1, "exec", "执行");

GetMat:RegisterExecOutput(1, "exec", "执行");

GetMat:SetFunctionName("GetMat");


return GetMat ;

