local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local venuscore = require "libvenuscore"
local BluePinInfo = require "bluecore.bluepininfo"

local OnAniEnd = BlueNode:extend();

function OnAniEnd:new(...)
  OnAniEnd.super.new(self, ...)
  self.edge = true;
end

function OnAniEnd:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnAniEnd:_OnNextBranch()
  if self.edge and not self.output.isEdge then 
    return 0
  else
    if self.aniName == self.output.aniName then
      WARNING("OnAniEnd--self.aniName: " .. self.aniName);
      WARNING("OnAniEnd--self.output.aniName: " .. self.output.aniName);
      return 1;
    else
      return 0;
    end
  end
end

function OnAniEnd:_GetCompOnPin1()

  if #self.inputs[1].links ~= 0 then

    local bluePinLink = self.inputs[1].links[1]
    local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
      self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
      return nil
    end

    if venuscore.isNil(otherNode.comp) then
      self.compileResult = BD.EHINT.COMP_LOST
      return nil
    end

    return otherNode.comp

  else
    self.compileResult = BD.EHINT.PIN_1_EMPTY;
  end
  return nil
end

function OnAniEnd:_IsCompPin(pin)
  return pin.pinType == BD.PIN_DATA_INPUT and pin.argId == 1
end

function OnAniEnd:_SetupInstanceInfoTable()
  -- 不需要序列化 但需要单独修改一个引脚的infoTable
  -- override  infoTable
  local staticExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticDataInputsInfo = self.infoTable[BD.PIN_DATA_INPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = staticDataOutputsInfo
  self.infoTable[BD.PIN_EXEC_INPUT]  = staticExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = staticExecOutputsInfo


  self.myUnFixComboType = Types.ComboType:extend();
  self.myUnFixComboType:SetData({},{});

  local pinInfo = staticDataInputsInfo[1]
  self.infoTable[BD.PIN_DATA_INPUT][1] =  staticDataInputsInfo[1]
  pinInfo = staticDataInputsInfo[2]
  self.infoTable[BD.PIN_DATA_INPUT][2] = BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, self.myUnFixComboType, pinInfo.name,pinInfo.tips,pinInfo.default,pinInfo.delAble, pinInfo.groupName);
  pinInfo = staticDataInputsInfo[3]
  self.infoTable[BD.PIN_DATA_INPUT][3] =  staticDataInputsInfo[3]
end


function OnAniEnd:_Reset()
  -- 引脚类型
  self.myUnFixComboType:SetData({},{});
  -- 字面值
  self.inputs[2].literal = ""
end

function OnAniEnd:_OnDeserialize()
  OnAniEnd.super._OnDeserialize(self);
  self:_SetupInstanceInfoTable();
end


function OnAniEnd:_OnCompile()
  -- pin1 有连接 && 必须是引用component,
  self.compileResult = nil
  if OnAniEnd.super._OnCompile(self) then
    local comp = self:_GetCompOnPin1();
    if comp then
      if comp:HasAnimation(self.inputs[2].literal) then
        return true
      else
        self.compileResult = BD.EHINT.ANI_NOT_EXIST;
      end
    end
  end
  return false
end

if _KRATOSEDITOR then

  function OnAniEnd:_OnLink(selfPin, otherNode, otherPin)
    if self:_IsCompPin(selfPin) then
      local comp = self:_GetCompOnPin1();
      if comp then
        local animations = comp:GetAnimations();
        local anis = {}
        for ani, _ in pairs(animations) do
          table.insert(anis, ani)
        end
        self.myUnFixComboType:SetData(anis, anis);
      end

    end
  end

  function OnAniEnd:_OnUnLink(unlinkPin)
    if self:_IsCompPin(unlinkPin) then
      self:_Reset();
    end
  end

  function OnAniEnd:_OnCreateWithEditor()
    OnAniEnd.super._OnCreateWithEditor(self);
    self:_SetupInstanceInfoTable();
  end

  function OnAniEnd:_OnUpdateByEditor()
    OnAniEnd.super._OnUpdateByEditor(self);
    self:_OnCompile();
  end

end

function OnAniEnd:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.aniName = self.inputArgs[2];
  self.edge = self.inputArgs[3];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.AnimationEvent.End, func, bluePrintSelf);
end

OnAniEnd:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnAniEnd:RegisterInput(2, Types.ComboType, "ani" , "动画曲线", BD.EMPTY_STRING); -- 不能是空串
OnAniEnd:RegisterInput(3, Types.BoolType, "edge", "边缘触发", true);

OnAniEnd:RegisterExecOutput(1, "OnTrigger", "执行");

OnAniEnd:SetFunctionName("_OnAnimationEndWithType");

OnAniEnd:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnAniEnd:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnAniEnd;

